/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.corpus.CorpusModel;
import ch.qos.logback.core.contention.RunnableWithCounterAndDone;
import ch.qos.logback.core.contention.ThreadedThroughputCalculator;
import org.junit.Before;
import org.junit.Test;

public class LoggerContextPerfTest {
    static int THREAD_COUNT = 10000;
    int totalTestDuration = 4000;
    LoggerContext loggerContext = new LoggerContext();
    ThreadedThroughputCalculator harness = new ThreadedThroughputCalculator((long)this.totalTestDuration);
    RunnableWithCounterAndDone[] runnableArray = this.buildRunnableArray();
    CorpusModel corpusMaker;

    @Before
    public void setUp() throws Exception {
    }

    private RunnableWithCounterAndDone[] buildRunnableArray() {
        RunnableWithCounterAndDone[] runnableArray = new RunnableWithCounterAndDone[THREAD_COUNT];
        for (int i = 0; i < THREAD_COUNT; ++i) {
            runnableArray[i] = new GetLoggerRunnable();
        }
        return runnableArray;
    }

    @Test
    public void computeResults() throws InterruptedException {
        this.harness.execute(this.runnableArray);
        this.harness.printThroughput("getLogger performance: ", true);
    }

    private class GetLoggerRunnable
    extends RunnableWithCounterAndDone {
        final int burstLength = 3;

        private GetLoggerRunnable() {
        }

        public void run() {
            while (!this.isDone()) {
                long i = this.counter % 3L;
                LoggerContextPerfTest.this.loggerContext.getLogger("a" + i);
                ++this.counter;
                if (i != 0L) continue;
                Thread.yield();
            }
        }
    }
}

