/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.rolling;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.ScaffoldingForRollingTests;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.status.StatusChecker;
import java.util.Date;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimeBasedRollingWithConfigFileTest
extends ScaffoldingForRollingTests {
    LoggerContext lc = new LoggerContext();
    StatusChecker statusChecker = new StatusChecker((Context)this.lc);
    Logger logger = this.lc.getLogger(((Object)((Object)this)).getClass());
    int fileSize = 0;
    int fileIndexCounter = -1;
    int sizeThreshold;

    @Before
    public void setUp() {
        this.lc.setName("test");
        super.setUp();
        this.lc.putProperty("randomOutputDir", this.randomOutputDir);
    }

    @After
    public void tearDown() throws Exception {
    }

    void loadConfig(String confifFile) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.lc);
        jc.doConfigure(confifFile);
        this.currentTime = System.currentTimeMillis();
        this.recomputeRolloverThreshold(this.currentTime);
    }

    @Test
    public void basic() throws Exception {
        String testId = "basic";
        this.lc.putProperty("testId", testId);
        this.loadConfig("src/test/input/joran/rolling/" + testId + ".xml");
        this.statusChecker.assertIsErrorFree();
        Logger root = this.lc.getLogger("ROOT");
        this.expectedFilenameList.add(this.randomOutputDir + "z" + testId);
        RollingFileAppender rfa = (RollingFileAppender)root.getAppender("ROLLING");
        TimeBasedRollingPolicy tprp = (TimeBasedRollingPolicy)rfa.getTriggeringPolicy();
        TimeBasedFileNamingAndTriggeringPolicy tbnatp = tprp.getTimeBasedFileNamingAndTriggeringPolicy();
        String prefix = "Hello---";
        int runLength = 4;
        for (int i = 0; i < runLength; ++i) {
            this.logger.debug(prefix + i);
            this.addExpectedFileNamedIfItsTime_ByDate(this.randomOutputDir, testId, false);
            this.incCurrentTime(500L);
            tbnatp.setCurrentTime(this.currentTime);
        }
        TimeBasedRollingWithConfigFileTest.existenceCheck((List)this.expectedFilenameList);
        TimeBasedRollingWithConfigFileTest.sortedContentCheck((String)this.randomOutputDir, (int)runLength, (String)prefix);
    }

    @Test
    public void timeAndSize() throws Exception {
        String testId = "timeAndSize";
        this.lc.putProperty("testId", testId);
        String prefix = "Hello-----";
        int approxWritesPerPeriod = 64;
        this.sizeThreshold = prefix.length() * approxWritesPerPeriod;
        this.lc.putProperty("sizeThreshold", "" + this.sizeThreshold);
        this.loadConfig("src/test/input/joran/rolling/" + testId + ".xml");
        Logger root = this.lc.getLogger("ROOT");
        this.expectedFilenameList.add(this.randomOutputDir + "z" + testId);
        RollingFileAppender rfa = (RollingFileAppender)root.getAppender("ROLLING");
        this.statusChecker.assertIsErrorFree();
        TimeBasedRollingPolicy tprp = (TimeBasedRollingPolicy)rfa.getTriggeringPolicy();
        TimeBasedFileNamingAndTriggeringPolicy tbnatp = tprp.getTimeBasedFileNamingAndTriggeringPolicy();
        int timeIncrement = 1000 / approxWritesPerPeriod;
        int runLength = approxWritesPerPeriod * 3;
        for (int i = 0; i < runLength; ++i) {
            String msg = prefix + i;
            this.logger.debug(msg);
            this.addExpectedFileNamedIfItsTime(testId, msg, false);
            this.incCurrentTime(timeIncrement);
            tbnatp.setCurrentTime(this.currentTime);
        }
        TimeBasedRollingWithConfigFileTest.sortedContentCheck((String)this.randomOutputDir, (int)runLength, (String)prefix);
        int eCount = TimeBasedRollingWithConfigFileTest.existenceCount((List)this.expectedFilenameList);
        Assert.assertTrue((String)("exitenceCount=" + eCount + ", expectedFilenameList.size=" + this.expectedFilenameList.size()), (eCount >= 4 && eCount > this.expectedFilenameList.size() / 2 ? 1 : 0) != 0);
    }

    void addExpectedFileNamedIfItsTime(String testId, String msg, boolean gzExtension) {
        this.fileSize += msg.getBytes().length;
        if (this.passThresholdTime(this.nextRolloverThreshold)) {
            this.fileIndexCounter = 0;
            this.fileSize = 0;
            this.addExpectedFileName(testId, this.getDateOfPreviousPeriodsStart(), this.fileIndexCounter, gzExtension);
            this.recomputeRolloverThreshold(this.currentTime);
            return;
        }
        if (this.fileIndexCounter < 1 && this.fileSize > this.sizeThreshold) {
            this.addExpectedFileName(testId, this.getDateOfPreviousPeriodsStart(), ++this.fileIndexCounter, gzExtension);
            this.fileSize = -1;
            return;
        }
    }

    void addExpectedFileName(String testId, Date date, int fileIndexCounter, boolean gzExtension) {
        String fn = this.randomOutputDir + testId + "-" + SDF.format(date) + "." + fileIndexCounter;
        System.out.println("Adding " + fn);
        if (gzExtension) {
            fn = fn + ".gz";
        }
        this.expectedFilenameList.add(fn);
    }

    protected void addExpectedFileNamedIfItsTime_ByDate(String outputDir, String testId, boolean gzExtension) {
        if (this.passThresholdTime(this.nextRolloverThreshold)) {
            this.addExpectedFileName_ByDate(outputDir, testId, this.getDateOfPreviousPeriodsStart(), gzExtension);
            this.recomputeRolloverThreshold(this.currentTime);
        }
    }
}

