/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.log4j;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.log4j.XMLLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XMLLayoutTest {
    private static final String DOCTYPE = "<!DOCTYPE log4j:eventSet SYSTEM \"http://logging.apache.org/log4j/1.2/apidocs/org/apache/log4j/xml/doc-files/log4j.dtd\">";
    private static final String NAMESPACE = "http://jakarta.apache.org/log4j/";
    private static final String DTD_URI = "http://logging.apache.org/log4j/1.2/apidocs/org/apache/log4j/xml/doc-files/log4j.dtd";
    private static final String MDC_KEY = "key <&>'\"]]>";
    private static final String MDC_VALUE = "value <&>'\"]]>";
    private static final String MESSAGE = "test message, <&>'\"";
    private LoggerContext lc;
    private Logger root;
    private XMLLayout layout;

    @Before
    public void setUp() throws Exception {
        this.lc = new LoggerContext();
        this.lc.setName("default");
        this.layout = new XMLLayout();
        this.layout.setLocationInfo(true);
        this.layout.setContext((Context)this.lc);
        this.layout.setProperties(true);
        this.layout.setLocationInfo(true);
        this.layout.start();
        this.root = this.lc.getLogger("ROOT");
    }

    @After
    public void tearDown() throws Exception {
        this.lc = null;
        this.layout = null;
    }

    @Test
    public void testDoLayout() throws Exception {
        LoggingEvent le = this.createLoggingEvent();
        String result = "<!DOCTYPE log4j:eventSet SYSTEM \"http://logging.apache.org/log4j/1.2/apidocs/org/apache/log4j/xml/doc-files/log4j.dtd\"><log4j:eventSet xmlns:log4j='http://jakarta.apache.org/log4j/'>";
        if (this.layout.getFileHeader() != null) {
            result = result + this.layout.getFileHeader();
        }
        if (this.layout.getPresentationHeader() != null) {
            result = result + this.layout.getPresentationHeader();
        }
        result = result + this.layout.doLayout((ILoggingEvent)le);
        if (this.layout.getPresentationFooter() != null) {
            result = result + this.layout.getPresentationFooter();
        }
        if (this.layout.getFileFooter() != null) {
            result = result + this.layout.getFileFooter();
        }
        result = result + "</log4j:eventSet>";
        Document document = this.parse(result);
        XPath xpath = this.newXPath();
        NodeList eventNodes = (NodeList)xpath.compile("//log4j:event").evaluate(document, XPathConstants.NODESET);
        Assert.assertEquals((long)1L, (long)eventNodes.getLength());
        Assert.assertEquals((Object)MESSAGE, (Object)xpath.compile("//log4j:message").evaluate(document, XPathConstants.STRING));
        NodeList dataNodes = (NodeList)xpath.compile("//log4j:data").evaluate(document, XPathConstants.NODESET);
        boolean foundMdc = false;
        for (int i = 0; i != dataNodes.getLength(); ++i) {
            Node dataNode = dataNodes.item(i);
            if (!dataNode.getAttributes().getNamedItem("name").getNodeValue().equals(MDC_KEY)) continue;
            foundMdc = true;
            Assert.assertEquals((Object)MDC_VALUE, (Object)dataNode.getAttributes().getNamedItem("value").getNodeValue());
            break;
        }
        Assert.assertTrue((boolean)foundMdc);
    }

    private XPath newXPath() {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        xpath.setNamespaceContext(new NamespaceContext(){

            public Iterator getPrefixes(String namespaceURI) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getPrefix(String namespaceURI) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getNamespaceURI(String prefix) {
                if ("log4j".equals(prefix)) {
                    return XMLLayoutTest.NAMESPACE;
                }
                return "";
            }
        });
        return xpath;
    }

    private LoggingEvent createLoggingEvent() {
        LoggingEvent event = new LoggingEvent("com.example.XMLLayoutTest-<&>'\"]]>", this.root, Level.DEBUG, MESSAGE, (Throwable)new RuntimeException("Dummy exception: <&>'\"]]>"), null);
        event.setThreadName("Dummy thread <&>'\"");
        event.getMDCPropertyMap().put(MDC_KEY, MDC_VALUE);
        StackTraceElement ste1 = new StackTraceElement("c1", "m1", "f1", 1);
        StackTraceElement ste2 = new StackTraceElement("c2", "m2", "f2", 2);
        event.setCallerData(new StackTraceElement[]{ste1, ste2});
        return event;
    }

    private Document parse(String output) throws Exception {
        EntityResolver resolver = new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                if (publicId == null && systemId != null && systemId.equals(XMLLayoutTest.DTD_URI)) {
                    String path = "/org/apache/log4j/xml/log4j.dtd";
                    InputStream in = this.getClass().getResourceAsStream("/org/apache/log4j/xml/log4j.dtd");
                    return new InputSource(in);
                }
                throw new RuntimeException("Not found");
            }
        };
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(resolver);
        return builder.parse(new ByteArrayInputStream(output.getBytes("UTF-8")));
    }
}

