/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.issue.lbclassic36;

import ch.qos.logback.core.contention.RunnableWithCounterAndDone;
import java.text.SimpleDateFormat;

public class SelectiveDateFormattingRunnable
extends RunnableWithCounterAndDone {
    public static final String ISO8601_PATTERN = "yyyy-MM-dd HH:mm:ss,SSS";
    FormattingModel model;
    static long CACHE = 0L;
    static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");

    SelectiveDateFormattingRunnable(FormattingModel model) {
        this.model = model;
    }

    public void run() {
        switch (this.model) {
            case SDF: {
                this.sdfRun();
                break;
            }
            case JODA: {
                this.jodaRun();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sdfRun() {
        do {
            SimpleDateFormat simpleDateFormat = SDF;
            synchronized (simpleDateFormat) {
                long now = System.currentTimeMillis();
                if (CACHE != now) {
                    CACHE = now;
                    SDF.format(now);
                }
            }
            ++this.counter;
        } while (!this.done);
    }

    void jodaRun() {
        do {
            long now;
            if (SelectiveDateFormattingRunnable.isCacheStale(now = System.currentTimeMillis())) {
                // empty if block
            }
            ++this.counter;
        } while (!this.done);
    }

    private static boolean isCacheStale(long now) {
        return false;
    }

    static enum FormattingModel {
        SDF,
        JODA;

    }
}

