/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.issue.logback920;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class TimeRotationTest {
    private static File _tmpDir;
    private Set<File> _filesExpected;
    LoggerContext context;

    @BeforeClass
    public static void setupForAll() throws Exception {
        String tmp = System.getProperty("java.io.tmpdir") + "/gztest/" + System.currentTimeMillis();
        System.out.println("tmp dir is " + tmp);
        _tmpDir = new File(tmp);
        _tmpDir.mkdirs();
        Assert.assertTrue((String)(_tmpDir + " not created"), (boolean)_tmpDir.isDirectory());
        Assert.assertEquals((String)(_tmpDir + " not empty"), (long)0L, (long)_tmpDir.list().length);
        for (String p : new String[]{"java.vendor", "java.version", "os.name", "os.version", "os.arch"}) {
            System.out.println(p + "=" + System.getProperty(p));
        }
        System.out.println("using " + _tmpDir.getAbsolutePath() + "\n");
    }

    @Before
    public void setup() {
        this.context = new LoggerContext();
        OnConsoleStatusListener.addNewInstanceToContext((Context)this.context);
        this._filesExpected = new HashSet<File>();
    }

    @After
    public void tearDown() {
    }

    private void verifyFile(File file, long maxSize) {
        String name = file.getName();
        Assert.assertTrue((String)(name + " duplicate"), (boolean)this._filesExpected.add(file));
        Assert.assertTrue((String)(name + " does not exist"), (boolean)file.canRead());
        Assert.assertTrue((String)(name + " size is zero"), (file.length() > 0L ? 1 : 0) != 0);
        float percent = 100.0f * (float)file.length() / (float)maxSize - 100.0f;
        String msg = String.format("%s size is %.1fMB which is %.1f%% more than %.1fMB requested", name, Float.valueOf((float)file.length() / 1024.0f / 1024.0f), Float.valueOf(percent), Float.valueOf((float)maxSize / 1024.0f / 1024.0f));
        Assert.assertTrue((String)msg, ((double)file.length() <= (double)maxSize * 1.1 ? 1 : 0) != 0);
    }

    private Appender<ILoggingEvent> createAppender(String basename_, String rotated_, long maxFileSize_, int maxFiles_, boolean append_) {
        SizeAndTimeBasedFNATP triggeringPolicy = new SizeAndTimeBasedFNATP();
        triggeringPolicy.setMaxFileSize(String.valueOf(maxFileSize_));
        TimeBasedRollingPolicy rollingPolicy = new TimeBasedRollingPolicy();
        rollingPolicy.setContext((Context)this.context);
        rollingPolicy.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)triggeringPolicy);
        rollingPolicy.setMaxHistory(maxFiles_ - 1);
        rollingPolicy.setFileNamePattern(rotated_);
        triggeringPolicy.setContext((Context)this.context);
        triggeringPolicy.setTimeBasedRollingPolicy(rollingPolicy);
        RollingFileAppender appender = new RollingFileAppender();
        appender.setFile(basename_);
        appender.setAppend(append_);
        appender.setRollingPolicy((RollingPolicy)rollingPolicy);
        appender.setTriggeringPolicy((TriggeringPolicy)triggeringPolicy);
        rollingPolicy.setParent((FileAppender)appender);
        rollingPolicy.start();
        triggeringPolicy.start();
        PatternLayoutEncoder layout = new PatternLayoutEncoder();
        layout.setPattern("%d{YYYY-MM-dd HH:mm:ss.SSS} [%thread] %level %logger %msg%n");
        layout.setContext((Context)this.context);
        layout.start();
        appender.setEncoder((Encoder)layout);
        appender.setContext((Context)this.context);
        appender.start();
        return appender;
    }

    private void doTest(String testname, String basenameS, String rotatedS, boolean compress, int maxFiles, long maxSize) throws Exception {
        int i;
        File testDir = new File(_tmpDir, testname);
        testDir.mkdirs();
        Assert.assertEquals((String)(testDir + " not empty"), (long)0L, (long)testDir.listFiles().length);
        File basename = new File(testDir, basenameS);
        File rotated = new File(testDir, rotatedS + (compress ? ".gz" : ""));
        boolean append = false;
        Appender<ILoggingEvent> appender = this.createAppender(basename.getPath(), rotated.getPath(), maxSize, maxFiles, append);
        Logger logger = this.context.getLogger(testname);
        logger.addAppender(appender);
        Random rnd = new Random();
        String msg = "{} During the application {} in the case long-lived application on {} when {} is another random";
        for (i = 0; i < 200000; ++i) {
            logger.info(msg, new Object[]{i, new Date(), rnd.nextGaussian()});
        }
        for (i = 0; i < maxFiles - 1; ++i) {
            String file = String.format(TimeRotationTest.resolveFilename(rotated.getPath()), i);
            this.verifyFile(new File(file), maxSize);
        }
        this.verifyFile(basename, maxSize);
        HashSet<File> filesPresent = new HashSet<File>(Arrays.asList(testDir.listFiles()));
        filesPresent.removeAll(this._filesExpected);
        if (filesPresent.isEmpty()) {
            Assert.fail((String)("unexpected " + filesPresent.size() + " files: " + filesPresent));
        }
    }

    private static String resolveFilename(String rotatedPattern_) {
        int j;
        String dateFormat = null;
        String DP = "%d{";
        int i = rotatedPattern_.indexOf("%d{");
        if (i > -1) {
            j = rotatedPattern_.indexOf(125);
            if (j > "%d{".length() + i) {
                dateFormat = rotatedPattern_.substring(i + "%d{".length(), j);
            }
        } else {
            dateFormat = "yyyy-MM-dd";
            i = rotatedPattern_.indexOf("%d");
            j = i + 1;
        }
        String s = rotatedPattern_.substring(0, i) + new SimpleDateFormat(dateFormat).format(new Date()) + rotatedPattern_.substring(j + 1);
        return s.replace("%i", "%d");
    }

    @Test
    @Ignore
    public void testOnePerDay_max2_30MB_gz() throws Exception {
        this.doTest("one_daily_max2_30MB_each_gz", "test.log", "test_%d.log.%i.gz", false, 2, 0x1E00000L);
    }

    @Test
    public void testOnePerDay_max2_15MB_gz() throws Exception {
        this.doTest("one_daily_max2_15MB_each_gz", "test.log", "test_%d.log.%i.gz", false, 2, 0xF00000L);
    }
}

