/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.db;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.hsqldb.Server;
import org.hsqldb.jdbcDriver;
import org.junit.Assert;

public class DBAppenderHSQLTestFixture {
    public static final String HSQLDB_DRIVER_CLASS = "org.hsqldb.jdbcDriver";
    String url = null;
    String user = "sa";
    String password = "";
    Server server;
    HsqlMode mode = HsqlMode.MEM;

    public void setUp() throws SQLException {
        switch (this.mode) {
            case NET: {
                this.url = "jdbc:hsqldb:hsql://localhost:4808/test";
                break;
            }
            case MEM: {
                this.url = "jdbc:hsqldb:mem:test;sql.enforce_strict_size=true";
                this.server = new Server();
                this.server.setDatabaseName(0, "test");
                this.server.setDatabasePath(0, this.url);
                this.server.setLogWriter(new PrintWriter(System.out));
                this.server.setErrWriter(new PrintWriter(System.out));
                this.server.setTrace(false);
                this.server.setSilent(false);
                this.server.start();
                break;
            }
            case FILE: {
                this.url = "jdbc:hsqldb:file:test;sql.enforce_strict_size=true";
            }
        }
        System.out.println(this.server.getState());
        int waitCount = 0;
        while (this.server.getState() != 1 && waitCount < 5) {
            try {
                ++waitCount;
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.createTables();
    }

    public void tearDown() throws SQLException {
        this.dropTables();
        if (this.mode == HsqlMode.MEM) {
            this.server.stop();
            this.server = null;
        }
    }

    Connection newConnection() throws SQLException {
        jdbcDriver driver = new jdbcDriver();
        Properties props = new Properties();
        props.setProperty("user", this.user);
        props.setProperty("password", this.password);
        return driver.connect(this.url, props);
    }

    private void createTables() throws SQLException {
        Connection conn = this.newConnection();
        Assert.assertNotNull((Object)conn);
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE TABLE LOGGING_EVENT (");
        buf.append("TIMESTMP BIGINT NOT NULL,");
        buf.append("FORMATTED_MESSAGE LONGVARCHAR NOT NULL,");
        buf.append("LOGGER_NAME VARCHAR(256) NOT NULL,");
        buf.append("LEVEL_STRING VARCHAR(256) NOT NULL,");
        buf.append("THREAD_NAME VARCHAR(256),");
        buf.append("REFERENCE_FLAG SMALLINT,");
        buf.append("ARG0 VARCHAR(256),");
        buf.append("ARG1 VARCHAR(256),");
        buf.append("ARG2 VARCHAR(256),");
        buf.append("ARG3 VARCHAR(256),");
        buf.append("CALLER_FILENAME VARCHAR(256), ");
        buf.append("CALLER_CLASS VARCHAR(256), ");
        buf.append("CALLER_METHOD VARCHAR(256), ");
        buf.append("CALLER_LINE CHAR(4), ");
        buf.append("EVENT_ID BIGINT NOT NULL IDENTITY);");
        this.query(conn, buf.toString());
        buf = new StringBuilder();
        buf.append("CREATE TABLE LOGGING_EVENT_PROPERTY (");
        buf.append("EVENT_ID BIGINT NOT NULL,");
        buf.append("MAPPED_KEY  VARCHAR(254) NOT NULL,");
        buf.append("MAPPED_VALUE LONGVARCHAR,");
        buf.append("PRIMARY KEY(EVENT_ID, MAPPED_KEY),");
        buf.append("FOREIGN KEY (EVENT_ID) REFERENCES LOGGING_EVENT(EVENT_ID));");
        this.query(conn, buf.toString());
        buf = new StringBuilder();
        buf.append("CREATE TABLE LOGGING_EVENT_EXCEPTION (");
        buf.append("EVENT_ID BIGINT NOT NULL,");
        buf.append("I SMALLINT NOT NULL,");
        buf.append("TRACE_LINE VARCHAR(256) NOT NULL,");
        buf.append("PRIMARY KEY(EVENT_ID, I),");
        buf.append("FOREIGN KEY (EVENT_ID) REFERENCES LOGGING_EVENT(EVENT_ID));");
        this.query(conn, buf.toString());
    }

    private void dropTables() throws SQLException {
        Connection conn = this.newConnection();
        StringBuilder buf = new StringBuilder();
        buf.append("DROP TABLE LOGGING_EVENT_EXCEPTION IF EXISTS;");
        this.query(conn, buf.toString());
        buf = new StringBuilder();
        buf.append("DROP TABLE LOGGING_EVENT_PROPERTY IF EXISTS;");
        this.query(conn, buf.toString());
        buf = new StringBuilder();
        buf.append("DROP TABLE LOGGING_EVENT IF EXISTS;");
        this.query(conn, buf.toString());
    }

    private void query(Connection conn, String expression) throws SQLException {
        Statement st = null;
        st = conn.createStatement();
        int i = st.executeUpdate(expression);
        if (i == -1) {
            System.out.println("db error : " + expression);
        }
        st.close();
    }

    public static enum HsqlMode {
        MEM,
        FILE,
        NET;

    }
}

