/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.db;

import ch.qos.logback.classic.db.SQLBuilder;
import ch.qos.logback.classic.db.names.DBNameResolver;
import ch.qos.logback.classic.db.names.DefaultDBNameResolver;
import ch.qos.logback.classic.db.names.SimpleDBNameResolver;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class SQLBuilderTest {
    @Test
    public void shouldReturnDefaultSqlInsertLoggingEventQuery() throws Exception {
        DefaultDBNameResolver nameResolver = new DefaultDBNameResolver();
        String sql = SQLBuilder.buildInsertSQL((DBNameResolver)nameResolver);
        Assertions.assertThat((String)sql).isEqualTo((Object)"INSERT INTO logging_event (timestmp, formatted_message, logger_name, level_string, thread_name, reference_flag, arg0, arg1, arg2, arg3, caller_filename, caller_class, caller_method, caller_line) VALUES (?, ?, ? ,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    }

    @Test
    public void shouldReturnDefaultSqlInsertExceptionQuery() throws Exception {
        DefaultDBNameResolver nameResolver = new DefaultDBNameResolver();
        String sql = SQLBuilder.buildInsertExceptionSQL((DBNameResolver)nameResolver);
        Assertions.assertThat((String)sql).isEqualTo((Object)"INSERT INTO logging_event_exception (event_id, i, trace_line) VALUES (?, ?, ?)");
    }

    @Test
    public void shouldReturnDefaultSqlInsertLoggingPropertyQuery() throws Exception {
        DefaultDBNameResolver nameResolver = new DefaultDBNameResolver();
        String sql = SQLBuilder.buildInsertPropertiesSQL((DBNameResolver)nameResolver);
        Assertions.assertThat((String)sql).isEqualTo((Object)"INSERT INTO logging_event_property (event_id, mapped_key, mapped_value) VALUES (?, ?, ?)");
    }

    private DBNameResolver createSimpleDBNameResolver() {
        SimpleDBNameResolver nameResolver = new SimpleDBNameResolver();
        nameResolver.setTableNamePrefix("tp_");
        nameResolver.setTableNameSuffix("_ts");
        nameResolver.setColumnNamePrefix("cp_");
        nameResolver.setColumnNameSuffix("_cs");
        return nameResolver;
    }

    @Test
    public void shouldReturnSimpleSqlInsertLoggingEventQuery() throws Exception {
        DBNameResolver nameResolver = this.createSimpleDBNameResolver();
        String sql = SQLBuilder.buildInsertSQL((DBNameResolver)nameResolver);
        Assertions.assertThat((String)sql).isEqualTo((Object)"INSERT INTO tp_logging_event_ts (cp_timestmp_cs, cp_formatted_message_cs, cp_logger_name_cs, cp_level_string_cs, cp_thread_name_cs, cp_reference_flag_cs, cp_arg0_cs, cp_arg1_cs, cp_arg2_cs, cp_arg3_cs, cp_caller_filename_cs, cp_caller_class_cs, cp_caller_method_cs, cp_caller_line_cs) VALUES (?, ?, ? ,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    }

    @Test
    public void shouldReturnSimpleSqlInsertExceptionQuery() throws Exception {
        DBNameResolver nameResolver = this.createSimpleDBNameResolver();
        String sql = SQLBuilder.buildInsertExceptionSQL((DBNameResolver)nameResolver);
        Assertions.assertThat((String)sql).isEqualTo((Object)"INSERT INTO tp_logging_event_exception_ts (cp_event_id_cs, cp_i_cs, cp_trace_line_cs) VALUES (?, ?, ?)");
    }

    @Test
    public void shouldReturnSimpleSqlInsertLoggingPropertyQuery() throws Exception {
        DBNameResolver nameResolver = this.createSimpleDBNameResolver();
        String sql = SQLBuilder.buildInsertPropertiesSQL((DBNameResolver)nameResolver);
        Assertions.assertThat((String)sql).isEqualTo((Object)"INSERT INTO tp_logging_event_property_ts (cp_event_id_cs, cp_mapped_key_cs, cp_mapped_value_cs) VALUES (?, ?, ?)");
    }
}

