/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.jmx;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.jmx.JMXConfigurator;
import ch.qos.logback.classic.jmx.MBeanUtil;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.lang.management.ManagementFactory;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JMXConfiguratorTest {
    MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    LoggerContext lc = new LoggerContext();
    Logger testLogger = this.lc.getLogger(this.getClass());
    List<LoggerContextListener> listenerList;
    int diff = RandomUtil.getPositiveInt();

    @Before
    public void setUp() throws Exception {
        this.lc.setName("context-" + this.diff);
        Assert.assertNotNull((Object)this.mbs);
    }

    @After
    public void tearDown() throws Exception {
        this.lc.stop();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.lc.getName() + ")";
    }

    @Test
    public void contextReset() throws Exception {
        String randomizedObjectNameAsStr = "ch.qos.logback." + this.diff + ":Name=" + this.lc.getName() + ",Type=" + this.getClass().getName();
        ObjectName objectName = MBeanUtil.string2ObjectName((Context)this.lc, (Object)this, (String)randomizedObjectNameAsStr);
        JMXConfigurator jmxConfigurator = new JMXConfigurator(this.lc, this.mbs, objectName);
        this.mbs.registerMBean(jmxConfigurator, objectName);
        this.listenerList = this.lc.getCopyOfListenerList();
        Assert.assertEquals((long)1L, (long)this.listenerList.size());
        this.lc.reset();
        this.listenerList = this.lc.getCopyOfListenerList();
        Assert.assertEquals((long)1L, (long)this.listenerList.size());
        Assert.assertTrue((boolean)this.listenerList.contains(jmxConfigurator));
        Assert.assertTrue((boolean)this.mbs.isRegistered(objectName));
    }

    @Test
    public void contextStop() throws Exception {
        String randomizedObjectNameAsStr = "ch.qos.logback." + this.diff + ":Name=" + this.lc.getName() + ",Type=" + this.getClass().getName();
        ObjectName objectName = MBeanUtil.string2ObjectName((Context)this.lc, (Object)this, (String)randomizedObjectNameAsStr);
        JMXConfigurator jmxConfigurator = new JMXConfigurator(this.lc, this.mbs, objectName);
        this.mbs.registerMBean(jmxConfigurator, objectName);
        this.listenerList = this.lc.getCopyOfListenerList();
        Assert.assertEquals((long)1L, (long)this.listenerList.size());
        this.lc.stop();
        this.listenerList = this.lc.getCopyOfListenerList();
        Assert.assertEquals((long)0L, (long)this.listenerList.size());
        Assert.assertFalse((boolean)this.mbs.isRegistered(objectName));
    }

    @Test
    public void testNonRemovalOfPreviousIntanceFromTheContextListenerList() {
        String objectNameAsStr = "ch.qos.logback.toto:Name=" + this.lc.getName() + ",Type=" + this.getClass().getName();
        ObjectName objectName = MBeanUtil.string2ObjectName((Context)this.lc, (Object)this, (String)objectNameAsStr);
        JMXConfigurator jmxConfigurator0 = new JMXConfigurator(this.lc, this.mbs, objectName);
        this.listenerList = this.lc.getCopyOfListenerList();
        Assert.assertTrue((boolean)this.listenerList.contains(jmxConfigurator0));
        JMXConfigurator jmxConfigurator1 = new JMXConfigurator(this.lc, this.mbs, objectName);
        this.listenerList = this.lc.getCopyOfListenerList();
        Assert.assertEquals((long)1L, (long)this.listenerList.size());
        Assert.assertTrue((String)"old configurator should be present", (boolean)this.listenerList.contains(jmxConfigurator0));
        Assert.assertFalse((String)"new configurator should be absent", (boolean)this.listenerList.contains(jmxConfigurator1));
    }

    @Test
    public void getLoggerLevel_LBCLASSIC_78() {
        String objectNameAsStr = "ch.qos" + this.diff + ":Name=" + this.lc.getName() + ",Type=" + this.getClass().getName();
        ObjectName on = MBeanUtil.string2ObjectName((Context)this.lc, (Object)this, (String)objectNameAsStr);
        JMXConfigurator configurator = new JMXConfigurator(this.lc, this.mbs, on);
        Assert.assertEquals((Object)"", (Object)configurator.getLoggerLevel(this.testLogger.getName()));
        MBeanUtil.unregister((LoggerContext)this.lc, (MBeanServer)this.mbs, (ObjectName)on, (Object)this);
    }

    @Test
    public void setLoggerLevel_LBCLASSIC_79() {
        String objectNameAsStr = "ch.qos" + this.diff + ":Name=" + this.lc.getName() + ",Type=" + this.getClass().getName();
        ObjectName on = MBeanUtil.string2ObjectName((Context)this.lc, (Object)this, (String)objectNameAsStr);
        JMXConfigurator configurator = new JMXConfigurator(this.lc, this.mbs, on);
        configurator.setLoggerLevel(this.testLogger.getName(), "DEBUG");
        Assert.assertEquals((Object)Level.DEBUG, (Object)this.testLogger.getLevel());
        configurator.setLoggerLevel(this.testLogger.getName(), "null");
        Assert.assertNull((Object)this.testLogger.getLevel());
        MBeanUtil.unregister((LoggerContext)this.lc, (MBeanServer)this.mbs, (ObjectName)on, (Object)this);
    }

    @Test
    public void testReloadDefaultConfiguration() throws Exception {
        String objectNameAsStr = "ch.qos" + this.diff + ":Name=" + this.lc.getName() + ",Type=" + this.getClass().getName();
        ObjectName on = MBeanUtil.string2ObjectName((Context)this.lc, (Object)this, (String)objectNameAsStr);
        JMXConfigurator configurator = new JMXConfigurator(this.lc, this.mbs, on);
        configurator.setLoggerLevel(this.testLogger.getName(), "DEBUG");
        Assert.assertEquals((Object)Level.DEBUG, (Object)this.testLogger.getLevel());
        configurator.reloadDefaultConfiguration();
        Assert.assertNull((Object)this.testLogger.getLevel());
        Assert.assertEquals((Object)Level.DEBUG, (Object)this.lc.getLogger("ROOT").getLevel());
        MBeanUtil.unregister((LoggerContext)this.lc, (MBeanServer)this.mbs, (ObjectName)on, (Object)this);
    }
}

