/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.JMSQueueAppender;
import ch.qos.logback.classic.net.JMSTopicAppenderTestApp;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.StatusPrinter;
import org.slf4j.LoggerFactory;

public class JMSQueueAppenderTestApp {
    public static void main(String[] args) {
        Logger logger = (Logger)LoggerFactory.getLogger(JMSTopicAppenderTestApp.class);
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        lc.reset();
        JMSQueueAppender appender = new JMSQueueAppender();
        appender.setContext((Context)lc);
        appender.setName("jmsQueue");
        appender.setInitialContextFactoryName("org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        appender.setProviderURL("tcp://localhost:61616");
        appender.setQueueBindingName("MyQueue");
        appender.setQueueConnectionFactoryBindingName("ConnectionFactory");
        appender.start();
        logger.addAppender((Appender)appender);
        int i = 0;
        while (i < 10000) {
            logger.debug("** Hello world. n=" + i);
            ++i;
        }
        long before = System.nanoTime();
        int i2 = 0;
        while (i2 < 10000) {
            logger.debug("** Hello world. n=" + i2);
            ++i2;
        }
        long after = System.nanoTime();
        System.out.println("Time per logs for 10'000 logs: " + (after - before) / 10000L);
        StatusPrinter.print((StatusManager)lc.getStatusManager());
    }
}

