/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.LoggerTestHelper;
import ch.qos.logback.classic.turbo.NOPTurboFilter;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.status.StatusManager;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LoggerContextTest {
    LoggerContext lc;

    @Before
    public void setUp() throws Exception {
        this.lc = new LoggerContext();
        this.lc.setName("x");
    }

    @Test
    public void testRootGetLogger() {
        Logger root = this.lc.getLogger("ROOT");
        Assert.assertEquals((Object)Level.DEBUG, (Object)root.getLevel());
        Assert.assertEquals((Object)Level.DEBUG, (Object)root.getEffectiveLevel());
    }

    @Test
    public void testLoggerX() {
        Logger x = this.lc.getLogger("x");
        Assert.assertNotNull((Object)x);
        Assert.assertEquals((Object)"x", (Object)x.getName());
        Assert.assertNull((Object)x.getLevel());
        Assert.assertEquals((Object)Level.DEBUG, (Object)x.getEffectiveLevel());
    }

    @Test
    public void testNull() {
        try {
            this.lc.getLogger(null);
            Assert.fail((String)"null should cause an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testEmpty() {
        Logger empty = this.lc.getLogger("");
        LoggerTestHelper.assertNameEquals(empty, "");
        LoggerTestHelper.assertLevels(null, empty, Level.DEBUG);
        Logger dot = this.lc.getLogger(".");
        LoggerTestHelper.assertNameEquals(dot, ".");
        LoggerTestHelper.assertLevels(null, dot, Level.DEBUG);
        Assert.assertEquals((long)3L, (long)this.lc.getLoggerList().size());
    }

    @Test
    public void testDotDot() {
        Logger dotdot = this.lc.getLogger("..");
        Assert.assertEquals((long)4L, (long)this.lc.getLoggerList().size());
        LoggerTestHelper.assertNameEquals(dotdot, "..");
    }

    int instanceCount() {
        return this.lc.getLoggerList().size();
    }

    @Test
    public void testLoggerXY() {
        Assert.assertEquals((long)1L, (long)this.lc.getLoggerList().size());
        Logger xy = this.lc.getLogger("x.y");
        Assert.assertEquals((long)3L, (long)this.instanceCount());
        LoggerTestHelper.assertNameEquals(xy, "x.y");
        LoggerTestHelper.assertLevels(null, xy, Level.DEBUG);
        Logger x = this.lc.getLogger("x");
        Assert.assertEquals((long)3L, (long)this.instanceCount());
        Logger xy2 = this.lc.getLogger("x.y");
        Assert.assertEquals((Object)xy, (Object)xy2);
        Logger x2 = this.lc.getLogger("x");
        Assert.assertEquals((Object)x, (Object)x2);
        Assert.assertEquals((long)3L, (long)this.instanceCount());
    }

    @Test
    public void testLoggerMultipleChildren() {
        Assert.assertEquals((long)1L, (long)this.instanceCount());
        Logger xy0 = this.lc.getLogger("x.y0");
        LoggerTestHelper.assertNameEquals(xy0, "x.y0");
        Logger xy1 = this.lc.getLogger("x.y1");
        LoggerTestHelper.assertNameEquals(xy1, "x.y1");
        LoggerTestHelper.assertLevels(null, xy0, Level.DEBUG);
        LoggerTestHelper.assertLevels(null, xy1, Level.DEBUG);
        Assert.assertEquals((long)4L, (long)this.instanceCount());
        int i = 0;
        while (i < 100) {
            Logger xy_i = this.lc.getLogger("x.y" + i);
            LoggerTestHelper.assertNameEquals(xy_i, "x.y" + i);
            LoggerTestHelper.assertLevels(null, xy_i, Level.DEBUG);
            ++i;
        }
        Assert.assertEquals((long)102L, (long)this.instanceCount());
    }

    @Test
    public void testMultiLevel() {
        Logger wxyz = this.lc.getLogger("w.x.y.z");
        LoggerTestHelper.assertNameEquals(wxyz, "w.x.y.z");
        LoggerTestHelper.assertLevels(null, wxyz, Level.DEBUG);
        Logger wx = this.lc.getLogger("w.x");
        wx.setLevel(Level.INFO);
        LoggerTestHelper.assertNameEquals(wx, "w.x");
        LoggerTestHelper.assertLevels(Level.INFO, wx, Level.INFO);
        LoggerTestHelper.assertLevels(null, this.lc.getLogger("w.x.y"), Level.INFO);
        LoggerTestHelper.assertLevels(null, wxyz, Level.INFO);
    }

    @Test
    public void testStatusWithUnconfiguredContext() {
        Logger logger = this.lc.getLogger(LoggerContextTest.class);
        int i = 0;
        while (i < 3) {
            logger.debug("test");
            ++i;
        }
        logger = this.lc.getLogger("x.y.z");
        i = 0;
        while (i < 3) {
            logger.debug("test");
            ++i;
        }
        StatusManager sm = this.lc.getStatusManager();
        Assert.assertTrue((String)"StatusManager has recieved too many messages", (sm.getCount() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void resetTest() {
        Logger root = this.lc.getLogger("ROOT");
        Logger a = this.lc.getLogger("a");
        Logger ab = this.lc.getLogger("a.b");
        ab.setLevel(Level.WARN);
        root.setLevel(Level.INFO);
        this.lc.reset();
        Assert.assertEquals((Object)Level.DEBUG, (Object)root.getEffectiveLevel());
        Assert.assertTrue((boolean)root.isDebugEnabled());
        Assert.assertEquals((Object)Level.DEBUG, (Object)a.getEffectiveLevel());
        Assert.assertEquals((Object)Level.DEBUG, (Object)ab.getEffectiveLevel());
        Assert.assertEquals((Object)Level.DEBUG, (Object)root.getLevel());
        Assert.assertNull((Object)a.getLevel());
        Assert.assertNull((Object)ab.getLevel());
    }

    @Test
    public void turboFilterStopOnReset() {
        NOPTurboFilter nopTF = new NOPTurboFilter();
        nopTF.start();
        this.lc.addTurboFilter((TurboFilter)nopTF);
        Assert.assertTrue((boolean)nopTF.isStarted());
        this.lc.reset();
        Assert.assertFalse((boolean)nopTF.isStarted());
    }

    @Test
    public void resetTest_LBCORE_104() {
        this.lc.putProperty("keyA", "valA");
        this.lc.putObject("keyA", (Object)"valA");
        Assert.assertEquals((Object)"valA", (Object)this.lc.getProperty("keyA"));
        Assert.assertEquals((Object)"valA", (Object)this.lc.getObject("keyA"));
        this.lc.reset();
        Assert.assertNull((Object)this.lc.getProperty("keyA"));
        Assert.assertNull((Object)this.lc.getObject("keyA"));
    }

    @Test
    public void loggerNameEndingInDotOrDollarShouldWork() {
        String loggerName = "toto.x.";
        Logger logger = this.lc.getLogger(loggerName);
        Assert.assertEquals((Object)loggerName, (Object)logger.getName());
        loggerName = "toto.x$";
        logger = this.lc.getLogger(loggerName);
        Assert.assertEquals((Object)loggerName, (Object)logger.getName());
    }

    @Test
    public void levelResetTest() {
        Logger root = this.lc.getLogger("ROOT");
        root.setLevel(Level.TRACE);
        Assert.assertTrue((boolean)root.isTraceEnabled());
        this.lc.reset();
        Assert.assertFalse((boolean)root.isTraceEnabled());
        Assert.assertTrue((boolean)root.isDebugEnabled());
    }

    @Test
    public void evaluatorMapPostReset() {
        this.lc.reset();
        Assert.assertNotNull((Object)this.lc.getObject("EVALUATOR_MAP"));
    }

    @Test
    public void collisionMapsPostReset() {
        this.lc.reset();
        Map fileCollisions = (Map)this.lc.getObject("FA_FILENAME_COLLISION_MAP");
        Assert.assertNotNull((Object)fileCollisions);
        Assert.assertTrue((boolean)fileCollisions.isEmpty());
        Map filenamePatternCollisionMap = (Map)this.lc.getObject("RFA_FILENAME_PATTERN_COLLISION_MAP");
        Assert.assertNotNull((Object)filenamePatternCollisionMap);
        Assert.assertTrue((boolean)filenamePatternCollisionMap.isEmpty());
    }

    @Test
    public void concurrentModification() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < 100) {
                    LoggerContextTest.this.lc.getLogger("a" + i);
                    Thread.yield();
                    ++i;
                }
            }
        });
        thread.start();
        int i = 0;
        while (i < 100) {
            this.lc.putProperty("a" + i, "val");
            Thread.yield();
            ++i;
        }
    }
}

