/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class ExternalMockSocketServer {
    static final String LOGGINGEVENT = "LoggingEvent";
    static final String LOGGINGEVENT2 = "LoggingEvent2";
    static final String MINIMALEXT = "MinimalExt";
    static final String MINIMALSER = "MinimalSer";
    static final int PORT = 4560;
    static int clientNumber;
    static List<String> msgList;
    static boolean finished;
    String className = "LoggingEvent";

    static {
        msgList = new ArrayList<String>();
        finished = false;
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            clientNumber = Integer.parseInt(args[0]);
            ExternalMockSocketServer.runServer();
        } else {
            ExternalMockSocketServer.usage("Wrong number of arguments.");
        }
    }

    static void usage(String msg) {
        System.err.println(msg);
        System.err.println("Usage: java " + ExternalMockSocketServer.class.getName() + " loopNumber");
        System.exit(1);
    }

    static void runServer() {
        try {
            System.out.println("Starting Server...");
            ServerSocket serverSocket = new ServerSocket(4560);
            System.out.println("Listening on port 4560");
            int j = 0;
            while (j < clientNumber) {
                int val;
                Socket socket = serverSocket.accept();
                System.out.println("New client accepted.");
                System.out.println("Connected to client at " + socket.getInetAddress());
                InputStream is = socket.getInputStream();
                long sum = 0L;
                while ((val = is.read()) != -1) {
                    int a = is.available();
                    sum += (long)(a + 1);
                    is.skip(a);
                }
                System.out.println(String.valueOf(sum / 1000L) + " KB");
                ++j;
            }
            serverSocket.close();
        }
        catch (Exception se) {
            se.printStackTrace();
        }
        System.out.println("Server finished.");
        finished = true;
    }
}

