/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.MDCConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.testUtil.RandomUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.MDC;

public class MDCConverterTest {
    LoggerContext lc;
    MDCConverter converter;
    int diff = RandomUtil.getPositiveInt();

    @Before
    public void setUp() throws Exception {
        this.lc = new LoggerContext();
        this.converter = new MDCConverter();
        this.converter.start();
        MDC.clear();
    }

    @After
    public void tearDown() throws Exception {
        this.lc = null;
        this.converter.stop();
        this.converter = null;
        MDC.clear();
    }

    @Test
    public void testConvertWithOneEntry() {
        String k = "MDCConverterTest_k" + this.diff;
        String v = "MDCConverterTest_v" + this.diff;
        MDC.put((String)k, (String)v);
        ILoggingEvent le = this.createLoggingEvent();
        String result = this.converter.convert(le);
        Assert.assertEquals((Object)(String.valueOf(k) + "=" + v), (Object)result);
    }

    @Test
    public void testConvertWithMultipleEntries() {
        MDC.put((String)"testKey", (String)"testValue");
        MDC.put((String)"testKey2", (String)"testValue2");
        ILoggingEvent le = this.createLoggingEvent();
        String result = this.converter.convert(le);
        boolean isConform = result.matches("testKey2?=testValue2?, testKey2?=testValue2?");
        Assert.assertTrue((String)(String.valueOf(result) + " is not conform"), (boolean)isConform);
    }

    private ILoggingEvent createLoggingEvent() {
        return new LoggingEvent(this.getClass().getName(), this.lc.getLogger("ROOT"), Level.DEBUG, "test message", null, null);
    }
}

