/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.contention.AbstractMultiThreadedHarness;
import ch.qos.logback.core.contention.RunnableWithCounterAndDone;
import ch.qos.logback.core.status.StatusChecker;
import java.util.concurrent.CyclicBarrier;
import org.junit.Test;

public class LoggerContextConcurrentResetTest {
    static int CONCURRENT_RESET_THREAD_COUNT = 10;

    @Test(timeout=2000L)
    public void concurrentReset() throws InterruptedException {
        LoggerContext loggerContext = new LoggerContext();
        CyclicBarrier cyclicBarrier = new CyclicBarrier(CONCURRENT_RESET_THREAD_COUNT);
        StatusChecker statusChecker = new StatusChecker((Context)loggerContext);
        int desiredResetCount = 100;
        RunnableWithCounterAndDone[] runnableArray = this.buildRunnableArray(loggerContext, cyclicBarrier);
        Harness harness = new Harness((Resetter)runnableArray[0], desiredResetCount);
        harness.execute(runnableArray);
        statusChecker.assertIsErrorFree();
    }

    private RunnableWithCounterAndDone[] buildRunnableArray(LoggerContext loggerContext, CyclicBarrier cyclicBarrier) {
        RunnableWithCounterAndDone[] rArray = new RunnableWithCounterAndDone[CONCURRENT_RESET_THREAD_COUNT];
        rArray[0] = new Resetter(loggerContext, cyclicBarrier);
        for (int i = 1; i < CONCURRENT_RESET_THREAD_COUNT; ++i) {
            rArray[i] = new GetLoggerRunnable(loggerContext, cyclicBarrier, "mouse-" + i);
        }
        return rArray;
    }

    static class Resetter
    extends RunnableWithCounterAndDone {
        LoggerContext loggerContext;
        CyclicBarrier cyclicBarrier;
        public int resetCount = 0;

        Resetter(LoggerContext loggerContext, CyclicBarrier cyclicBarrier) {
            this.loggerContext = loggerContext;
            this.cyclicBarrier = cyclicBarrier;
        }

        public void run() {
            try {
                this.cyclicBarrier.await();
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (!this.isDone()) {
                this.loggerContext.reset();
                ++this.counter;
                Thread.yield();
            }
        }
    }

    static class GetLoggerRunnable
    extends RunnableWithCounterAndDone {
        final int burstLength = 30;
        LoggerContext loggerContext;
        CyclicBarrier cyclicBarrier;
        String nameSuffix;

        GetLoggerRunnable(LoggerContext loggerContext, CyclicBarrier cyclicBarrier, String nameSuffix) {
            this.loggerContext = loggerContext;
            this.cyclicBarrier = cyclicBarrier;
            this.nameSuffix = nameSuffix;
        }

        public void run() {
            try {
                this.cyclicBarrier.await();
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (!this.isDone()) {
                long i = this.counter % 30L;
                this.loggerContext.getLogger("org.bla." + this.nameSuffix + ".x" + i);
                ++this.counter;
                if (i != 0L) continue;
                Thread.yield();
            }
        }
    }

    class Harness
    extends AbstractMultiThreadedHarness {
        int desiredResetCount;
        Resetter resetter;

        Harness(Resetter resetter, int desiredResetCount) {
            this.resetter = resetter;
            this.desiredResetCount = desiredResetCount;
        }

        public void waitUntilEndCondition() throws InterruptedException {
            while (this.resetter.getCounter() < (long)this.desiredResetCount) {
                Thread.yield();
            }
        }
    }
}

