/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.issue.logback_1754;

import ch.qos.logback.core.testUtil.RandomUtil;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackTest {
    private static final int THREADS = 16;

    private void runTest() {
        int diff = RandomUtil.getPositiveInt();
        System.setProperty("logback.configurationFile", "src/test/input/issue/logback-1754.xml");
        System.setProperty("logback_1754_targetDirectory", "target/test-output/safeWrite_" + diff);
        CountDownLatch latch = new CountDownLatch(16);
        ArrayList<Thread> threads = new ArrayList<Thread>(16);
        for (int i = 0; i < 16; ++i) {
            Thread thread = new LoggerThread(latch, "message from thread " + i);
            thread.start();
            threads.add(thread);
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    public static void main(String ... args) {
        new LogbackTest().runTest();
    }

    private static final class LoggerThread
    extends Thread {
        private static final Logger LOG = LoggerFactory.getLogger(LoggerThread.class);
        private final CountDownLatch latch;
        private final String message;

        LoggerThread(CountDownLatch latch, String message) {
            this.setDaemon(false);
            this.latch = latch;
            this.message = message;
        }

        @Override
        public void run() {
            this.latch.countDown();
            LOG.info(this.message);
        }
    }
}

