/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.corpus;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.corpus.ExceptionBuilder;
import ch.qos.logback.classic.corpus.LogStatement;
import ch.qos.logback.classic.corpus.MessageArgumentTuple;
import ch.qos.logback.classic.corpus.RandomUtil;
import ch.qos.logback.classic.spi.ClassPackagingData;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyVO;
import java.util.List;
import java.util.Random;

public class CorpusModel {
    static final int AVERAGE_LOGGER_NAME_PARTS = 6;
    static final int STD_DEV_FOR_LOGGER_NAME_PARTS = 3;
    static final int LOGGER_POOL_SIZE = 1000;
    static final int LOG_STATEMENT_POOL_SIZE = 8000;
    static final double[] LEVEL_DISTRIBUTION = new double[]{0.3, 0.3, 0.9, 0.95};
    static final int AVERAGE_MESSAGE_WORDS = 8;
    static final int STD_DEV_FOR_MESSAGE_WORDS = 4;
    static final double[] ARGUMENT_DISTRIBUTION = new double[]{0.8, 0.88, 0.95};
    static final double THROWABLE_PROPABILITY_FOR_WARNING = 0.1;
    static final double THROWABLE_PROPABILITY_FOR_ERRORS = 0.3;
    static final double NESTING_PROBABILITY = 0.5;
    static final int AVERAGE_MILLIS_INCREMENT = 10;
    static final int STD_DEV_FOR_MILLIS_INCREMENT = 5;
    static final int THREAD_POOL_SIZE = 10;
    final Random random;
    final List<String> worldList;
    String[] threadNamePool;
    LogStatement[] logStatementPool;
    String[] loggerNamePool;
    long lastTimeStamp = 1236344888578L;

    public CorpusModel(long seed, List<String> worldList) {
        this.random = new Random(seed);
        this.worldList = worldList;
        this.buildThreadNamePool();
        this.buildLoggerNamePool();
        this.buildLogStatementPool();
    }

    private void buildThreadNamePool() {
        this.threadNamePool = new String[10];
        for (int i = 0; i < 10; ++i) {
            this.threadNamePool[i] = "CorpusMakerThread-" + i;
        }
    }

    private void buildLoggerNamePool() {
        this.loggerNamePool = new String[1000];
        for (int i = 0; i < 1000; ++i) {
            this.loggerNamePool[i] = this.makeRandomLoggerName();
        }
    }

    private void buildLogStatementPool() {
        this.logStatementPool = new LogStatement[8000];
        for (int i = 0; i < 8000; ++i) {
            this.logStatementPool[i] = this.makeRandomLogStatement(this.loggerNamePool);
        }
    }

    private int[] getRandomAnchorPositions(int wordCount, int numAnchors) {
        int[] positionsIndex = new int[numAnchors];
        for (int i = 0; i < numAnchors; ++i) {
            positionsIndex[i] = this.random.nextInt(wordCount);
        }
        return positionsIndex;
    }

    private String[] getRandomWords(int n) {
        String[] wordArray = new String[n];
        for (int i = 0; i < n; ++i) {
            wordArray[i] = this.getRandomWord();
        }
        return wordArray;
    }

    public long getRandomLong() {
        return this.random.nextLong();
    }

    public String getRandomThreadNameFromPool() {
        int index = this.random.nextInt(10);
        return this.threadNamePool[index];
    }

    public LogStatement getRandomLogStatementFromPool() {
        int index = this.random.nextInt(this.logStatementPool.length);
        return this.logStatementPool[index];
    }

    private String getRandomLoggerNameFromPool(String[] loggerNamePool) {
        int index = this.random.nextInt(loggerNamePool.length);
        return loggerNamePool[index];
    }

    public long getRandomTimeStamp() {
        this.lastTimeStamp += (long)(RandomUtil.gaussianAsPositiveInt(this.random, 10, 5) - 1);
        return this.lastTimeStamp;
    }

    LoggerContextVO getRandomlyNamedLoggerContextVO() {
        LoggerContext lc = new LoggerContext();
        lc.setName(this.getRandomJavaIdentifier());
        return new LoggerContextVO(lc);
    }

    String getRandomWord() {
        int size = this.worldList.size();
        int randomIndex = this.random.nextInt(size);
        return this.worldList.get(randomIndex);
    }

    String extractLastPart(String loggerName) {
        int i = loggerName.lastIndexOf(46);
        if (i == -1) {
            return loggerName;
        }
        return loggerName.substring(i + 1);
    }

    public StackTraceElement[] getRandomCallerData(int depth, String loggerName) {
        StackTraceElement cd;
        StackTraceElement[] cda = new StackTraceElement[depth];
        cda[0] = cd = new StackTraceElement(loggerName, this.getRandomJavaIdentifier(), this.extractLastPart(loggerName), 0);
        for (int i = 1; i < depth; ++i) {
            String ln = this.getRandomLoggerNameFromPool(this.loggerNamePool);
            cda[i] = new StackTraceElement(ln, this.getRandomJavaIdentifier(), this.extractLastPart(ln), i * 10);
        }
        return cda;
    }

    public Object[] getRandomArgumentArray(int numOfArguments) {
        if (numOfArguments == 0) {
            return null;
        }
        Object[] argumentArray = new Object[numOfArguments];
        for (int i = 0; i < numOfArguments; ++i) {
            argumentArray[i] = new Long(this.random.nextLong());
        }
        return argumentArray;
    }

    private MessageArgumentTuple makeRandomMessageArgumentTuple() {
        int[] anchorPositions;
        int numOfArguments = this.getNumberOfMessageArguments();
        int wordCount = RandomUtil.gaussianAsPositiveInt(this.random, 8, 4);
        String[] wordArray = this.getRandomWords(wordCount);
        for (int anchorIndex : anchorPositions = this.getRandomAnchorPositions(wordCount, numOfArguments)) {
            wordArray[anchorIndex] = "{}";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < wordCount; ++i) {
            sb.append(wordArray[i]).append(' ');
        }
        sb.append(this.getRandomWord());
        return new MessageArgumentTuple(sb.toString(), numOfArguments);
    }

    private LogStatement makeRandomLogStatement(String[] loggerNamePool) {
        MessageArgumentTuple mat = this.makeRandomMessageArgumentTuple();
        String loggerName = this.getRandomLoggerNameFromPool(loggerNamePool);
        Level randomLevel = this.getRandomLevel();
        Throwable t = this.getRandomThrowable(randomLevel);
        ThrowableProxyVO throwableProxy = null;
        if (t != null) {
            throwableProxy = ThrowableProxyVO.build((IThrowableProxy)new ThrowableProxy(t));
            this.pupulateWithPackagingData(throwableProxy.getStackTraceElementProxyArray());
        }
        return new LogStatement(loggerName, randomLevel, mat, (IThrowableProxy)throwableProxy);
    }

    private Throwable getRandomThrowable(Level level) {
        double rn = this.random.nextDouble();
        if (level == Level.WARN && rn < 0.1 || level == Level.ERROR && rn < 0.3) {
            return ExceptionBuilder.build(this.random, 0.5);
        }
        return null;
    }

    private void pupulateWithPackagingData(StackTraceElementProxy[] stepArray) {
        int i = 0;
        for (StackTraceElementProxy step : stepArray) {
            String identifier = "na";
            String version = "na";
            if (i++ % 2 == 0) {
                identifier = this.getRandomJavaIdentifier();
                version = this.getRandomJavaIdentifier();
            }
            ClassPackagingData cpd = new ClassPackagingData(identifier, version);
            step.setClassPackagingData(cpd);
        }
    }

    private int getNumberOfMessageArguments() {
        double rn = this.random.nextDouble();
        if (rn < ARGUMENT_DISTRIBUTION[0]) {
            return 0;
        }
        if (rn < ARGUMENT_DISTRIBUTION[1]) {
            return 1;
        }
        if (rn < ARGUMENT_DISTRIBUTION[2]) {
            return 2;
        }
        return 3;
    }

    String getRandomJavaIdentifier() {
        String w = this.getRandomWord();
        w = w.replaceAll("\\p{Punct}", "");
        return w;
    }

    private String makeRandomLoggerName() {
        int parts = RandomUtil.gaussianAsPositiveInt(this.random, 6, 3);
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < parts; ++i) {
            sb.append(this.getRandomJavaIdentifier()).append('.');
        }
        sb.append(this.getRandomJavaIdentifier());
        return sb.toString();
    }

    private Level getRandomLevel() {
        double rn = this.random.nextDouble();
        if (rn < LEVEL_DISTRIBUTION[0]) {
            return Level.TRACE;
        }
        if (rn < LEVEL_DISTRIBUTION[1]) {
            return Level.DEBUG;
        }
        if (rn < LEVEL_DISTRIBUTION[2]) {
            return Level.INFO;
        }
        if (rn < LEVEL_DISTRIBUTION[3]) {
            return Level.WARN;
        }
        return Level.ERROR;
    }
}

