/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.turbo;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.issue.lbclassic135.LoggingRunnable;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.TurboFilterList;
import ch.qos.logback.classic.turbo.ReconfigureOnChangeFilter;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.contention.AbstractMultiThreadedHarness;
import ch.qos.logback.core.contention.RunnableWithCounterAndDone;
import ch.qos.logback.core.contention.WaitOnExecutionMultiThreadedHarness;
import ch.qos.logback.core.joran.spi.ConfigurationWatchList;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.testUtil.EnvUtilForTests;
import ch.qos.logback.core.testUtil.FileTestUtil;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.helpers.BogoPerf;

@Ignore
public class ReconfigureOnChangeTest {
    static final int THREAD_COUNT = 5;
    static final int LOOP_LEN = 1000000;
    int diff = RandomUtil.getPositiveInt();
    static final String SCAN1_FILE_AS_STR = "src/test/input/turbo/scan 1.xml";
    static final String G_SCAN1_FILE_AS_STR = "src/test/input/turbo/scan 1.groovy";
    static final String SCAN_LOGBACK_474_FILE_AS_STR = "src/test/input/turbo/scan_logback_474.xml";
    static final String INCLUSION_SCAN_TOPLEVEL0_AS_STR = "src/test/input/turbo/inclusion/topLevel0.xml";
    static final String INCLUSION_SCAN_TOP_BY_RESOURCE_AS_STR = "src/test/input/turbo/inclusion/topByResource.xml";
    static final String INCLUSION_SCAN_INNER0_AS_STR = "src/test/input/turbo/inclusion/inner0.xml";
    static final String INCLUSION_SCAN_INNER1_AS_STR = "target/test-classes/asResource/inner1.xml";
    int sleepBetweenUpdates = 100;
    LoggerContext loggerContext = new LoggerContext();
    Logger logger = this.loggerContext.getLogger(this.getClass());
    ExecutorService executorService = this.loggerContext.getExecutorService();
    StatusChecker checker = new StatusChecker((Context)this.loggerContext);
    AbstractMultiThreadedHarness harness;
    ThreadPoolExecutor executor = (ThreadPoolExecutor)this.loggerContext.getExecutorService();
    int expectedResets = 2;

    @BeforeClass
    public static void classSetup() {
        FileTestUtil.makeTestOutputDir();
    }

    @Before
    public void setUp() {
        this.harness = new WaitOnExecutionMultiThreadedHarness(this.executor, this.expectedResets);
    }

    @After
    public void tearDown() {
    }

    void configure(File file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.loggerContext);
        jc.doConfigure(file);
    }

    void configure(InputStream is) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.loggerContext);
        jc.doConfigure(is);
    }

    RunnableWithCounterAndDone[] buildRunnableArray(File configFile, UpdateType updateType) {
        RunnableWithCounterAndDone[] rArray = new RunnableWithCounterAndDone[5];
        rArray[0] = new Updater(configFile, updateType);
        for (int i = 1; i < 5; ++i) {
            rArray[i] = new LoggingRunnable((org.slf4j.Logger)this.logger);
        }
        return rArray;
    }

    @Test
    public void installFilter() throws JoranException, IOException, InterruptedException {
        File file = new File(SCAN1_FILE_AS_STR);
        this.configure(file);
        List<File> fileList = this.getConfigurationFileList(this.loggerContext);
        this.assertThatListContainsFile(fileList, file);
        this.assertThatFirstFilterIsROCF();
        StatusPrinter.print((Context)this.loggerContext);
    }

    private void rocfDetachReconfigurationToNewThreadAndAwaitTermination() throws InterruptedException {
        ReconfigureOnChangeFilter reconfigureOnChangeFilter = (ReconfigureOnChangeFilter)this.getFirstTurboFilter();
        reconfigureOnChangeFilter.detachReconfigurationToNewThread();
        this.executorService.shutdown();
        this.executorService.awaitTermination(1000L, TimeUnit.MILLISECONDS);
    }

    List<File> getConfigurationFileList(LoggerContext context) {
        ConfigurationWatchList configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList((Context)this.loggerContext);
        return configurationWatchList.getCopyOfFileWatchList();
    }

    @Test(timeout=4000L)
    public void scanWithFileInclusion() throws JoranException, IOException, InterruptedException {
        File topLevelFile = new File(INCLUSION_SCAN_TOPLEVEL0_AS_STR);
        File innerFile = new File(INCLUSION_SCAN_INNER0_AS_STR);
        this.configure(topLevelFile);
        List<File> fileList = this.getConfigurationFileList(this.loggerContext);
        this.assertThatListContainsFile(fileList, topLevelFile);
        this.assertThatListContainsFile(fileList, innerFile);
    }

    @Test(timeout=4000L)
    public void scanWithResourceInclusion() throws JoranException, IOException, InterruptedException {
        File topLevelFile = new File(INCLUSION_SCAN_TOP_BY_RESOURCE_AS_STR);
        File innerFile = new File(INCLUSION_SCAN_INNER1_AS_STR);
        this.configure(topLevelFile);
        List<File> fileList = this.getConfigurationFileList(this.loggerContext);
        this.assertThatListContainsFile(fileList, topLevelFile);
        this.assertThatListContainsFile(fileList, innerFile);
    }

    @Test
    public void includeScanViaInputStreamSuppliedConfigFile() throws IOException, JoranException, InterruptedException {
        String configurationStr = "<configuration scan=\"true\" scanPeriod=\"50 millisecond\"><include resource=\"asResource/inner1.xml\"/></configuration>";
        this.configure(new ByteArrayInputStream(configurationStr.getBytes("UTF-8")));
        ConfigurationWatchList configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList((Context)this.loggerContext);
        Assert.assertNull((Object)configurationWatchList.getMainURL());
        ReconfigureOnChangeFilter reconfigureOnChangeFilter = (ReconfigureOnChangeFilter)this.getFirstTurboFilter();
        Assert.assertFalse((boolean)reconfigureOnChangeFilter.isStarted());
    }

    @Test(timeout=4000L)
    public void fallbackToSafe() throws IOException, JoranException, InterruptedException {
        String path = "target/test-output/reconfigureOnChangeConfig_fallbackToSafe-" + this.diff + ".xml";
        File topLevelFile = new File(path);
        this.writeToFile(topLevelFile, "<configuration scan=\"true\" scanPeriod=\"50 millisecond\"><root level=\"ERROR\"/></configuration> ");
        this.configure(topLevelFile);
        this.writeToFile(topLevelFile, "<configuration scan=\"true\" scanPeriod=\"50 millisecond\">\n  <root></configuration>");
        this.rocfDetachReconfigurationToNewThreadAndAwaitTermination();
        this.checker.assertContainsMatch(1, "Falling back to previously registered safe configuration.");
        this.checker.assertContainsMatch(0, "Re-registering previous fallback configuration once more");
        this.assertThatFirstFilterIsROCF();
    }

    @Test(timeout=4000L)
    public void fallbackToSafeWithIncludedFile() throws IOException, JoranException, InterruptedException {
        String topLevelFileAsStr = "target/test-output/reconfigureOnChangeConfig_top-" + this.diff + ".xml";
        String innerFileAsStr = "target/test-output/reconfigureOnChangeConfig_inner-" + this.diff + ".xml";
        File topLevelFile = new File(topLevelFileAsStr);
        this.writeToFile(topLevelFile, "<configuration scan=\"true\" scanPeriod=\"50 millisecond\"><include file=\"" + innerFileAsStr + "\"/></configuration> ");
        File innerFile = new File(innerFileAsStr);
        this.writeToFile(innerFile, "<included><root level=\"ERROR\"/></included> ");
        this.configure(topLevelFile);
        this.writeToFile(innerFile, "<included>\n<root>\n</included>");
        this.rocfDetachReconfigurationToNewThreadAndAwaitTermination();
        this.checker.assertContainsMatch(1, "Falling back to previously registered safe configuration.");
        this.checker.assertContainsMatch(0, "Re-registering previous fallback configuration once more");
        this.assertThatFirstFilterIsROCF();
    }

    @Test(timeout=4000L)
    public void scan_LOGBACK_474() throws JoranException, IOException, InterruptedException {
        File file = new File(SCAN_LOGBACK_474_FILE_AS_STR);
        this.configure(file);
        RunnableWithCounterAndDone[] runnableArray = this.buildRunnableArray(file, UpdateType.TOUCH);
        this.harness.execute(runnableArray);
        this.loggerContext.getStatusManager().add((Status)new InfoStatus("end of execution ", (Object)this));
        this.verify(this.expectedResets);
    }

    private void assertThatListContainsFile(List<File> fileList, File file) {
        Assert.assertTrue((boolean)fileList.contains(file.getAbsoluteFile()));
    }

    private TurboFilter getFirstTurboFilter() {
        TurboFilterList turboFilterList = this.loggerContext.getTurboFilterList();
        return (TurboFilter)turboFilterList.get(0);
    }

    private void assertThatFirstFilterIsROCF() {
        Assert.assertTrue((boolean)(this.getFirstTurboFilter() instanceof ReconfigureOnChangeFilter));
    }

    private void verify(int expected) {
        StatusChecker checker = new StatusChecker((Context)this.loggerContext);
        checker.assertIsErrorFree();
        int effectiveResets = checker.matchCount("Will reset and reconfigure context ");
        String failMsg = "effective=" + effectiveResets + ", expected=" + expected;
        Assert.assertTrue((String)failMsg, (expected <= effectiveResets && expected + 2 >= effectiveResets ? 1 : 0) != 0);
    }

    ReconfigureOnChangeFilter initROCF() throws MalformedURLException {
        ReconfigureOnChangeFilter rocf = new ReconfigureOnChangeFilter();
        rocf.setContext((Context)this.loggerContext);
        File file = new File(SCAN1_FILE_AS_STR);
        ConfigurationWatchListUtil.setMainWatchURL((Context)this.loggerContext, (URL)file.toURI().toURL());
        rocf.start();
        return rocf;
    }

    @Test
    @Ignore
    public void directPerfTest() throws MalformedURLException {
        if (EnvUtilForTests.isLinux()) {
            return;
        }
        ReconfigureOnChangeFilter rocf = this.initROCF();
        Assert.assertTrue((boolean)rocf.isStarted());
        for (int i = 0; i < 30; ++i) {
            this.directLoop(rocf);
        }
        double avg = this.directLoop(rocf);
        System.out.println("directPerfTest: " + avg);
    }

    public double directLoop(ReconfigureOnChangeFilter rocf) {
        long start = System.nanoTime();
        for (int i = 0; i < 1000000; ++i) {
            rocf.decide(null, this.logger, Level.DEBUG, " ", null, null);
        }
        long end = System.nanoTime();
        return (double)(end - start) / 1000000.0;
    }

    @Ignore
    @Test
    public void indirectPerfTest() throws MalformedURLException {
        if (EnvUtilForTests.isLinux()) {
            return;
        }
        ReconfigureOnChangeFilter rocf = this.initROCF();
        Assert.assertTrue((boolean)rocf.isStarted());
        this.loggerContext.addTurboFilter((TurboFilter)rocf);
        this.logger.setLevel(Level.ERROR);
        this.indirectLoop();
        double avg = this.indirectLoop();
        System.out.println(avg);
        long referencePerf = 68L;
        BogoPerf.assertDuration((double)avg, (long)referencePerf, (double)CoreConstants.REFERENCE_BIPS);
    }

    void addInfo(String msg, Object o) {
        this.loggerContext.getStatusManager().add((Status)new InfoStatus(msg, o));
    }

    public double indirectLoop() {
        long start = System.nanoTime();
        for (int i = 0; i < 1000000; ++i) {
            this.logger.debug("hello");
        }
        long end = System.nanoTime();
        return (double)(end - start) / 1000000.0;
    }

    void writeToFile(File file, String contents) throws IOException {
        FileWriter fw = new FileWriter(file);
        fw.write(contents);
        fw.close();
    }

    class Updater
    extends RunnableWithCounterAndDone {
        File configFile;
        UpdateType updateType;

        Updater(File configFile, UpdateType updateType) {
            this.configFile = configFile;
            this.updateType = updateType;
        }

        Updater(File configFile) {
            this(configFile, UpdateType.TOUCH);
        }

        public void run() {
            while (!this.isDone()) {
                try {
                    Thread.sleep(ReconfigureOnChangeTest.this.sleepBetweenUpdates);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.isDone()) {
                    return;
                }
                ++this.counter;
                ReconfigureOnChangeTest.this.addInfo("***settting last modified", (Object)this);
                switch (this.updateType) {
                    case TOUCH: {
                        this.touchFile();
                        break;
                    }
                    case MALFORMED: {
                        try {
                            this.malformedUpdate();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            Assert.fail((String)"malformedUpdate failed");
                        }
                        break;
                    }
                    case MALFORMED_INNER: {
                        try {
                            this.malformedInnerUpdate();
                            break;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            Assert.fail((String)"malformedInnerUpdate failed");
                        }
                    }
                }
            }
        }

        private void malformedUpdate() throws IOException {
            ReconfigureOnChangeTest.this.writeToFile(this.configFile, "<configuration scan=\"true\" scanPeriod=\"50 millisecond\">\n  <root level=\"ERROR\">\n</configuration>");
        }

        private void malformedInnerUpdate() throws IOException {
            ReconfigureOnChangeTest.this.writeToFile(this.configFile, "<included>\n  <root>\n</included>");
        }

        void touchFile() {
            this.configFile.setLastModified(System.currentTimeMillis());
        }
    }

    static enum UpdateType {
        TOUCH,
        MALFORMED,
        MALFORMED_INNER;

    }
}

