/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.LoggingEventPreSerializationTransformer;
import ch.qos.logback.classic.net.server.HardenedLoggingEventInputStream;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.LuckyCharms;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyVO;
import ch.qos.logback.core.spi.PreSerializationTransformer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.MDC;

public class LoggingEventSerializationTest {
    LoggerContext loggerContext;
    Logger logger;
    ByteArrayOutputStream bos;
    ObjectOutputStream oos;
    ObjectInputStream inputStream;
    PreSerializationTransformer<ILoggingEvent> pst = new LoggingEventPreSerializationTransformer();

    @Before
    public void setUp() throws Exception {
        this.loggerContext = new LoggerContext();
        this.loggerContext.setName("testContext");
        this.logger = this.loggerContext.getLogger("ROOT");
        this.bos = new ByteArrayOutputStream();
        this.oos = new ObjectOutputStream(this.bos);
    }

    @After
    public void tearDown() throws Exception {
        this.loggerContext = null;
        this.logger = null;
        this.oos.close();
    }

    @Test
    public void smoke() throws Exception {
        LoggingEvent event = this.createLoggingEvent();
        ILoggingEvent remoteEvent = this.writeAndRead((ILoggingEvent)event);
        this.checkForEquality((ILoggingEvent)event, remoteEvent);
    }

    @Test
    public void context() throws Exception {
        this.loggerContext.putProperty("testKey", "testValue");
        LoggingEvent event = this.createLoggingEvent();
        ILoggingEvent remoteEvent = this.writeAndRead((ILoggingEvent)event);
        this.checkForEquality((ILoggingEvent)event, remoteEvent);
        Assert.assertNotNull((Object)remoteEvent.getLoggerName());
        Assert.assertEquals((Object)"ROOT", (Object)remoteEvent.getLoggerName());
        LoggerContextVO loggerContextRemoteView = remoteEvent.getLoggerContextVO();
        Assert.assertNotNull((Object)loggerContextRemoteView);
        Assert.assertEquals((Object)"testContext", (Object)loggerContextRemoteView.getName());
        Map props = loggerContextRemoteView.getPropertyMap();
        Assert.assertNotNull((Object)props);
        Assert.assertEquals((Object)"testValue", props.get("testKey"));
    }

    @Test
    public void MDC() throws Exception {
        MDC.put((String)"key", (String)"testValue");
        LoggingEvent event = this.createLoggingEvent();
        ILoggingEvent remoteEvent = this.writeAndRead((ILoggingEvent)event);
        this.checkForEquality((ILoggingEvent)event, remoteEvent);
        Map MDCPropertyMap = remoteEvent.getMDCPropertyMap();
        Assert.assertEquals((Object)"testValue", MDCPropertyMap.get("key"));
    }

    @Test
    public void updatedMDC() throws Exception {
        MDC.put((String)"key", (String)"testValue");
        LoggingEvent event1 = this.createLoggingEvent();
        Serializable s1 = this.pst.transform((Object)event1);
        this.oos.writeObject(s1);
        MDC.put((String)"key", (String)"updatedTestValue");
        LoggingEvent event2 = this.createLoggingEvent();
        Serializable s2 = this.pst.transform((Object)event2);
        this.oos.writeObject(s2);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.bos.toByteArray());
        this.inputStream = new ObjectInputStream(bis);
        this.inputStream.readObject();
        ILoggingEvent remoteEvent2 = (ILoggingEvent)this.inputStream.readObject();
        Map MDCPropertyMap = remoteEvent2.getMDCPropertyMap();
        Assert.assertEquals((Object)"updatedTestValue", MDCPropertyMap.get("key"));
    }

    @Test
    public void nonSerializableParameters() throws Exception {
        LoggingEvent event = this.createLoggingEvent();
        LuckyCharms lucky0 = new LuckyCharms(0);
        event.setArgumentArray(new Object[]{lucky0, null});
        ILoggingEvent remoteEvent = this.writeAndRead((ILoggingEvent)event);
        this.checkForEquality((ILoggingEvent)event, remoteEvent);
        Object[] aa = remoteEvent.getArgumentArray();
        Assert.assertNotNull((Object)aa);
        Assert.assertEquals((long)2L, (long)aa.length);
        Assert.assertEquals((Object)"LC(0)", (Object)aa[0]);
        Assert.assertNull((Object)aa[1]);
    }

    @Test
    public void testWithThrowable() throws Exception {
        Throwable throwable = new Throwable("just testing");
        LoggingEvent event = this.createLoggingEventWithThrowable(throwable);
        ILoggingEvent remoteEvent = this.writeAndRead((ILoggingEvent)event);
        this.checkForEquality((ILoggingEvent)event, remoteEvent);
    }

    @Test
    public void testWithCallerData() throws Exception {
        LoggingEvent event = this.createLoggingEvent();
        event.getCallerData();
        ILoggingEvent remoteEvent = this.writeAndRead((ILoggingEvent)event);
        this.checkForEquality((ILoggingEvent)event, remoteEvent);
    }

    @Test
    public void extendendeThrowable() throws Exception {
        LoggingEvent event = this.createLoggingEvent();
        Throwable throwable = new Throwable("just testing");
        ThrowableProxy tp = new ThrowableProxy(throwable);
        event.setThrowableProxy(tp);
        tp.calculatePackagingData();
        ILoggingEvent remoteEvent = this.writeAndRead((ILoggingEvent)event);
        this.checkForEquality((ILoggingEvent)event, remoteEvent);
    }

    @Test
    public void serializeLargeArgs() throws Exception {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 100000; ++i) {
            buffer.append("X");
        }
        String largeString = buffer.toString();
        Object[] argArray = new Object[]{new LuckyCharms(2), largeString};
        LoggingEvent event = this.createLoggingEvent();
        event.setArgumentArray(argArray);
        ILoggingEvent remoteEvent = this.writeAndRead((ILoggingEvent)event);
        this.checkForEquality((ILoggingEvent)event, remoteEvent);
        Object[] aa = remoteEvent.getArgumentArray();
        Assert.assertNotNull((Object)aa);
        Assert.assertEquals((long)2L, (long)aa.length);
        String stringBack = (String)aa[1];
        Assert.assertEquals((Object)largeString, (Object)stringBack);
    }

    private LoggingEvent createLoggingEvent() {
        return new LoggingEvent(this.getClass().getName(), this.logger, Level.DEBUG, "test message", null, null);
    }

    private LoggingEvent createLoggingEventWithThrowable(Throwable t) {
        return new LoggingEvent(this.getClass().getName(), this.logger, Level.DEBUG, "test message", t, null);
    }

    private void checkForEquality(ILoggingEvent original, ILoggingEvent afterSerialization) {
        Assert.assertEquals((Object)original.getLevel(), (Object)afterSerialization.getLevel());
        Assert.assertEquals((Object)original.getFormattedMessage(), (Object)afterSerialization.getFormattedMessage());
        Assert.assertEquals((Object)original.getMessage(), (Object)afterSerialization.getMessage());
        System.out.println();
        ThrowableProxyVO witness = ThrowableProxyVO.build((IThrowableProxy)original.getThrowableProxy());
        Assert.assertEquals((Object)witness, (Object)afterSerialization.getThrowableProxy());
    }

    private ILoggingEvent writeAndRead(ILoggingEvent event) throws IOException, ClassNotFoundException {
        Serializable ser = this.pst.transform((Object)event);
        this.oos.writeObject(ser);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.bos.toByteArray());
        this.inputStream = new HardenedLoggingEventInputStream((InputStream)bis);
        return (ILoggingEvent)this.inputStream.readObject();
    }
}

