/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.net.NOPOutputStream;
import ch.qos.logback.classic.net.testObjectBuilders.Builder;
import ch.qos.logback.classic.net.testObjectBuilders.MinimalSerBuilder;
import ch.qos.logback.classic.net.testObjectBuilders.TrivialLoggingEventVOBuilder;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import junit.framework.TestCase;

public class SerializationPerfTest
extends TestCase {
    ObjectOutputStream oos;
    int loopNumber = 10000;
    int resetFrequency = 100;
    int pauseFrequency = 10;
    long pauseLengthInMillis = 20L;
    boolean runWithExternalMockServer = true;

    public void setUp() throws Exception {
        super.setUp();
        this.oos = this.runWithExternalMockServer ? new ObjectOutputStream(new Socket("localhost", 4560).getOutputStream()) : new ObjectOutputStream(new NOPOutputStream());
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.oos.close();
        this.oos = null;
    }

    public void runPerfTest(Builder<?> builder, String label) throws Exception {
        int resetCounter = 0;
        int pauseCounter = 0;
        for (int i = 0; i < this.loopNumber; ++i) {
            try {
                this.oos.writeObject(builder.build(i));
                this.oos.flush();
                if (++resetCounter >= this.resetFrequency) {
                    this.oos.reset();
                    resetCounter = 0;
                }
                if (++pauseCounter < this.pauseFrequency) continue;
                Thread.sleep(this.pauseLengthInMillis);
                pauseCounter = 0;
                continue;
            }
            catch (IOException ex) {
                SerializationPerfTest.fail((String)ex.getMessage());
            }
        }
        Long total = 0L;
        resetCounter = 0;
        pauseCounter = 0;
        for (int i = 0; i < this.loopNumber; ++i) {
            try {
                Long t1 = System.nanoTime();
                this.oos.writeObject(builder.build(i));
                this.oos.flush();
                Long t2 = System.nanoTime();
                total = total + (t2 - t1);
                if (++resetCounter >= this.resetFrequency) {
                    this.oos.reset();
                    resetCounter = 0;
                }
                if (++pauseCounter < this.pauseFrequency) continue;
                Thread.sleep(this.pauseLengthInMillis);
                pauseCounter = 0;
                continue;
            }
            catch (IOException ex) {
                SerializationPerfTest.fail((String)ex.getMessage());
            }
        }
        total = total / 1000L;
        System.out.println(label + " : average time = " + total / (long)this.loopNumber + " microsecs after " + this.loopNumber + " writes.");
    }

    public void testWithMinimalSerialization() throws Exception {
        MinimalSerBuilder builder = new MinimalSerBuilder();
        this.runPerfTest(builder, "Minimal object serialization");
    }

    public void testWithSerialization() throws Exception {
        TrivialLoggingEventVOBuilder builder = new TrivialLoggingEventVOBuilder();
        this.runPerfTest(builder, "LoggingEventVO object serialization");
    }
}

