/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.selector;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.selector.ContextDetachingSCLTest;
import ch.qos.logback.classic.selector.ContextJNDISelector;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.classic.util.ContextSelectorStaticBinder;
import ch.qos.logback.classic.util.MockInitialContext;
import ch.qos.logback.classic.util.MockInitialContextFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.LoggerFactory;
import org.slf4j.LoggerFactoryFriend;

public class ContextJNDISelectorTest {
    static String INITIAL_CONTEXT_KEY = "java.naming.factory.initial";

    @Before
    public void setUp() throws Exception {
        System.setProperty("logback.ContextSelector", "JNDI");
        LoggerFactoryFriend.reset();
        MockInitialContextFactory.initialize();
        MockInitialContext mic = MockInitialContextFactory.getContext();
        mic.map.put("java:comp/env/logback/context-name", "toto");
        System.setProperty(INITIAL_CONTEXT_KEY, MockInitialContextFactory.class.getName());
        LoggerFactory.getLogger(ContextDetachingSCLTest.class);
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty(INITIAL_CONTEXT_KEY);
    }

    @Test
    public void testGetExistingContext() {
        ContextSelector selector = ContextSelectorStaticBinder.getSingleton().getContextSelector();
        LoggerContext context = selector.getLoggerContext();
        Assert.assertEquals((Object)"toto", (Object)context.getName());
    }

    @Test
    public void testCreateContext() {
        MockInitialContext mic = MockInitialContextFactory.getContext();
        mic.map.put("java:comp/env/logback/context-name", "tata");
        LoggerFactory.getLogger(ContextDetachingSCLTest.class);
        ContextJNDISelector selector = (ContextJNDISelector)ContextSelectorStaticBinder.getSingleton().getContextSelector();
        LoggerContext context = selector.getLoggerContext();
        Assert.assertEquals((Object)"tata", (Object)context.getName());
        System.out.println(selector.getContextNames());
        Assert.assertEquals((long)2L, (long)selector.getCount());
    }

    @Test
    public void defaultContext() {
        MockInitialContext mic = MockInitialContextFactory.getContext();
        mic.map.put("java:comp/env/logback/context-name", null);
        ContextJNDISelector selector = (ContextJNDISelector)ContextSelectorStaticBinder.getSingleton().getContextSelector();
        LoggerContext context = selector.getLoggerContext();
        Assert.assertEquals((Object)"default", (Object)context.getName());
    }
}

