/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.turbo;

import ch.qos.logback.classic.turbo.MDCFilter;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.testUtil.RandomUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.MDC;

public class MDCFilterTest {
    int diff = RandomUtil.getPositiveInt();
    String key = "myKey" + this.diff;
    String value = "val" + this.diff;
    private MDCFilter filter;

    @Before
    public void setUp() {
        this.filter = new MDCFilter();
        this.filter.setOnMatch("ACCEPT");
        this.filter.setOnMismatch("DENY");
        this.filter.setMDCKey(this.key);
        this.filter.setValue(this.value);
        MDC.clear();
    }

    @After
    public void tearDown() {
        MDC.clear();
    }

    @Test
    public void smoke() {
        this.filter.start();
        MDC.put((String)this.key, (String)("other" + this.diff));
        Assert.assertEquals((Object)FilterReply.DENY, (Object)this.filter.decide(null, null, null, null, null, null));
        MDC.put((String)this.key, null);
        Assert.assertEquals((Object)FilterReply.DENY, (Object)this.filter.decide(null, null, null, null, null, null));
        MDC.put((String)this.key, (String)this.value);
        Assert.assertEquals((Object)FilterReply.ACCEPT, (Object)this.filter.decide(null, null, null, null, null, null));
    }

    @Test
    public void testNoValueOption() {
        this.filter.setValue(null);
        this.filter.start();
        Assert.assertFalse((boolean)this.filter.isStarted());
        MDC.put((String)this.key, null);
        Assert.assertEquals((Object)FilterReply.NEUTRAL, (Object)this.filter.decide(null, null, null, null, null, null));
        MDC.put((String)this.key, (String)this.value);
        Assert.assertEquals((Object)FilterReply.NEUTRAL, (Object)this.filter.decide(null, null, null, null, null, null));
    }

    @Test
    public void testNoMDCKeyOption() {
        this.filter.setMDCKey(null);
        this.filter.start();
        Assert.assertFalse((boolean)this.filter.isStarted());
        MDC.put((String)this.key, null);
        Assert.assertEquals((Object)FilterReply.NEUTRAL, (Object)this.filter.decide(null, null, null, null, null, null));
        MDC.put((String)this.key, (String)this.value);
        Assert.assertEquals((Object)FilterReply.NEUTRAL, (Object)this.filter.decide(null, null, null, null, null, null));
    }
}

