/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.read.ListAppender;
import java.util.List;
import java.util.Random;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.LoggerFactoryFriend;
import org.slf4j.helpers.SubstituteLogger;

public class MultithreadedInitializationTest {
    static final int THREAD_COUNT = 4 + Runtime.getRuntime().availableProcessors() * 2;
    private static AtomicLong EVENT_COUNT = new AtomicLong(0L);
    final CyclicBarrier barrier = new CyclicBarrier(THREAD_COUNT + 1);
    int diff = new Random().nextInt(10000);
    String loggerName = "org.slf4j.impl.MultithreadedInitializationTest";

    @Before
    public void setUp() throws Exception {
        System.setProperty("logback.configurationFile", "src/test/input/listAppender.xml");
        LoggerFactoryFriend.reset();
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty("logback.configurationFile");
    }

    @Test
    public void multiThreadedInitialization() throws InterruptedException, BrokenBarrierException {
        LoggerAccessingThread[] accessors;
        for (LoggerAccessingThread accessor : accessors = MultithreadedInitializationTest.harness()) {
            EVENT_COUNT.getAndIncrement();
            accessor.logger.info("post harness");
        }
        Logger logger = LoggerFactory.getLogger((String)(this.loggerName + ".slowInitialization-" + this.diff));
        logger.info("hello");
        EVENT_COUNT.getAndIncrement();
        List<ILoggingEvent> events = this.getRecordedEvents();
        Assert.assertEquals((long)EVENT_COUNT.get(), (long)events.size());
    }

    private List<ILoggingEvent> getRecordedEvents() {
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        ListAppender la = (ListAppender)root.getAppender("LIST");
        Assert.assertNotNull((Object)la);
        return la.list;
    }

    private static LoggerAccessingThread[] harness() throws InterruptedException, BrokenBarrierException {
        int i;
        LoggerAccessingThread[] threads = new LoggerAccessingThread[THREAD_COUNT];
        CyclicBarrier barrier = new CyclicBarrier(THREAD_COUNT + 1);
        for (i = 0; i < THREAD_COUNT; ++i) {
            threads[i] = new LoggerAccessingThread(barrier, i);
            threads[i].start();
        }
        barrier.await();
        for (i = 0; i < THREAD_COUNT; ++i) {
            threads[i].join();
        }
        return threads;
    }

    static class LoggerAccessingThread
    extends Thread {
        final CyclicBarrier barrier;
        Logger logger;
        int count;

        LoggerAccessingThread(CyclicBarrier barrier, int count) {
            this.barrier = barrier;
            this.count = count;
        }

        @Override
        public void run() {
            try {
                this.barrier.await();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.logger = LoggerFactory.getLogger((String)(this.getClass().getName() + "-" + this.count));
            this.logger.info("in run method");
            if (this.logger instanceof SubstituteLogger) {
                SubstituteLogger substLogger = (SubstituteLogger)this.logger;
                if (!substLogger.createdPostInitialization) {
                    EVENT_COUNT.getAndIncrement();
                }
            } else {
                EVENT_COUNT.getAndIncrement();
            }
        }
    }
}

