/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.encoder;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.testUtil.StatusChecker;
import ch.qos.logback.core.util.StatusPrinter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LayoutInsteadOfEncoderTest {
    JoranConfigurator jc = new JoranConfigurator();
    LoggerContext loggerContext = new LoggerContext();

    @Before
    public void setUp() {
        this.jc.setContext((Context)this.loggerContext);
    }

    @Test
    public void layoutInsteadOfEncoer() throws JoranException {
        this.jc.doConfigure("src/test/input/joran/compatibility/layoutInsteadOfEncoder.xml");
        StatusPrinter.print((Context)this.loggerContext);
        StatusChecker checker = new StatusChecker((Context)this.loggerContext);
        checker.assertContainsMatch(1, "This appender no longer admits a layout as a sub-component");
        checker.assertContainsMatch(1, "See also http://logback.qos.ch/codes.html#layoutInsteadOfEncoder for details");
        Logger root = this.loggerContext.getLogger("ROOT");
        FileAppender fileAppender = (FileAppender)root.getAppender("LIOE");
        Assert.assertTrue((boolean)fileAppender.isStarted());
        Assert.assertTrue((boolean)(fileAppender.getEncoder() instanceof LayoutWrappingEncoder));
    }

    @Test
    public void immediateFlushInEncoder_TRUE() throws JoranException {
        this.immediateFlushInEncoder(true);
    }

    @Test
    public void immediateFlushInEncoder_FALSE() throws JoranException {
        this.immediateFlushInEncoder(false);
    }

    public void immediateFlushInEncoder(Boolean immediateFlush) throws JoranException {
        this.loggerContext.putProperty("immediateFlush", immediateFlush.toString());
        this.jc.doConfigure("src/test/input/joran/compatibility/immediateFlushInEncoder.xml");
        StatusPrinter.print((Context)this.loggerContext);
        StatusChecker checker = new StatusChecker((Context)this.loggerContext);
        checker.assertContainsMatch(1, "As of version 1.2.0 \"immediateFlush\" property should be set within the enclosing Appender.");
        checker.assertContainsMatch(1, "Please move \"immediateFlush\" property into the enclosing appender.");
        checker.assertContainsMatch(1, "Setting the \"immediateFlush\" property of the enclosing appender to " + immediateFlush);
        Logger root = this.loggerContext.getLogger("ROOT");
        FileAppender fileAppender = (FileAppender)root.getAppender("LIOE");
        Assert.assertTrue((boolean)fileAppender.isStarted());
        Assert.assertEquals((Object)immediateFlush, (Object)fileAppender.isImmediateFlush());
    }
}

