/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.SyslogStartConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class SyslogStartConverterTest {
    private LoggerContext lc;
    private SyslogStartConverter converter;
    private final String HOSTNAME = SyslogStartConverterTest.findHostname();
    private final Calendar calendar = Calendar.getInstance(Locale.US);

    @Before
    public void setUp() throws Exception {
        this.lc = new LoggerContext();
        this.converter = new SyslogStartConverter();
        this.converter.setOptionList(Arrays.asList("local7"));
        this.converter.start();
    }

    @After
    public void tearDown() throws Exception {
        this.lc = null;
        this.converter.stop();
        this.converter = null;
    }

    @Test
    public void datesLessThanTen() {
        LoggingEvent le = this.createLoggingEvent();
        this.calendar.set(2012, 7, 7, 13, 15, 0);
        le.setTimeStamp(this.calendar.getTimeInMillis());
        Assert.assertEquals((Object)("<191>Aug  7 13:15:00 " + this.HOSTNAME + " "), (Object)this.converter.convert((ILoggingEvent)le));
    }

    @Test
    public void datesGreaterThanTen() {
        LoggingEvent le = this.createLoggingEvent();
        this.calendar.set(2012, 9, 11, 22, 14, 15);
        le.setTimeStamp(this.calendar.getTimeInMillis());
        Assert.assertEquals((Object)("<191>Oct 11 22:14:15 " + this.HOSTNAME + " "), (Object)this.converter.convert((ILoggingEvent)le));
    }

    @Test
    public void multipleConversions() {
        LoggingEvent le = this.createLoggingEvent();
        this.calendar.set(2012, 9, 11, 22, 14, 15);
        le.setTimeStamp(this.calendar.getTimeInMillis());
        Assert.assertEquals((Object)("<191>Oct 11 22:14:15 " + this.HOSTNAME + " "), (Object)this.converter.convert((ILoggingEvent)le));
        Assert.assertEquals((Object)("<191>Oct 11 22:14:15 " + this.HOSTNAME + " "), (Object)this.converter.convert((ILoggingEvent)le));
        this.calendar.set(2012, 9, 11, 22, 14, 16);
        le.setTimeStamp(this.calendar.getTimeInMillis());
        Assert.assertEquals((Object)("<191>Oct 11 22:14:16 " + this.HOSTNAME + " "), (Object)this.converter.convert((ILoggingEvent)le));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void ignoreDefaultLocale() {
        Locale originalDefaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.TRADITIONAL_CHINESE);
        try {
            this.converter.start();
            LoggingEvent le = this.createLoggingEvent();
            this.calendar.set(2012, 9, 11, 22, 14, 15);
            le.setTimeStamp(this.calendar.getTimeInMillis());
            String result = this.converter.convert((ILoggingEvent)le);
            Assert.assertEquals((Object)("<191>Oct 11 22:14:15 " + this.HOSTNAME + " "), (Object)result);
        }
        finally {
            Locale.setDefault(originalDefaultLocale);
        }
    }

    @Test
    @Ignore
    public void hostnameShouldNotIncludeDomain() throws Exception {
        String host = this.HOSTNAME;
        int firstPeriod = host.indexOf(".");
        if (firstPeriod != -1) {
            host = host.substring(0, firstPeriod);
        }
        LoggingEvent le = this.createLoggingEvent();
        this.calendar.set(2012, 9, 11, 22, 14, 15);
        le.setTimeStamp(this.calendar.getTimeInMillis());
        Assert.assertEquals((Object)("<191>Oct 11 22:14:15 " + host + " "), (Object)this.converter.convert((ILoggingEvent)le));
    }

    private LoggingEvent createLoggingEvent() {
        return new LoggingEvent(this.getClass().getName(), this.lc.getLogger("ROOT"), Level.DEBUG, "test message", null, null);
    }

    private static String findHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "UNKNOWN_LOCALHOST";
        }
    }
}

