/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.servlet;

import ch.qos.logback.classic.servlet.LogbackServletContainerInitializer;
import ch.qos.logback.classic.servlet.LogbackServletContextListener;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.util.EventListener;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class LogbackServletContainerInitializerTest {
    LogbackServletContainerInitializer lsci = new LogbackServletContainerInitializer();

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testOnStartup() throws ServletException {
        ServletContext mockedServletContext = (ServletContext)Mockito.mock(ServletContext.class);
        this.lsci.onStartup(null, mockedServletContext);
        ((ServletContext)Mockito.verify((Object)mockedServletContext)).addListener((EventListener)((LogbackServletContextListener)ArgumentMatchers.any(LogbackServletContextListener.class)));
    }

    @Test
    public void noListenerShouldBeAddedWhenDisabled() throws ServletException {
        ServletContext mockedServletContext = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)mockedServletContext.getInitParameter("logbackDisableServletContainerInitializer")).thenReturn((Object)"true");
        this.lsci.onStartup(null, mockedServletContext);
        ((ServletContext)Mockito.verify((Object)mockedServletContext, (VerificationMode)Mockito.times((int)0))).addListener((EventListener)((LogbackServletContextListener)ArgumentMatchers.any(LogbackServletContextListener.class)));
    }
}

