/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.multiJVM;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.testUtil.RandomUtil;

public class FileAppenderPerf {
    static String msgLong = "ABCDEGHIJKLMNOPQRSTUVWXYZabcdeghijklmnopqrstuvwxyz1234567890";
    static long LEN = 100000L;
    static int DIFF = RandomUtil.getPositiveInt() % 1000;
    static String FILENAME;

    static LoggerContext buildLoggerContext(String filename, boolean safetyMode) {
        LoggerContext loggerContext = new LoggerContext();
        FileAppender fa = new FileAppender();
        PatternLayoutEncoder patternLayout = new PatternLayoutEncoder();
        patternLayout.setPattern("%5p %c - %m%n");
        patternLayout.setContext((Context)loggerContext);
        patternLayout.start();
        fa.setEncoder((Encoder)patternLayout);
        fa.setFile(filename);
        fa.setAppend(false);
        fa.setPrudent(safetyMode);
        fa.setContext((Context)loggerContext);
        fa.start();
        Logger root = loggerContext.getLogger("ROOT");
        root.addAppender((Appender)fa);
        return loggerContext;
    }

    static void usage(String msg) {
        System.err.println(msg);
        System.err.println("Usage: java " + FileAppenderPerf.class.getName() + " filename");
        System.exit(1);
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length > 1) {
            FileAppenderPerf.usage("Wrong number of arguments.");
        }
        FILENAME = argv.length == 0 ? DIFF + "" : argv[0];
        FileAppenderPerf.perfCase(false);
        FileAppenderPerf.perfCase(true);
    }

    static void perfCase(boolean safetyMode) throws Exception {
        LoggerContext lc = FileAppenderPerf.buildLoggerContext(FILENAME + "-" + safetyMode + ".log", safetyMode);
        Logger logger = lc.getLogger(FileAppenderPerf.class);
        long start = System.nanoTime();
        int i = 0;
        while ((long)i < LEN) {
            logger.debug(msgLong + " " + i);
            ++i;
        }
        double durationPerLog = (double)(System.nanoTime() - start) / ((double)LEN * 1000.0);
        lc.stop();
        System.out.println("Average duration of " + durationPerLog + " microseconds per log. Prudent mode=" + safetyMode);
        System.out.println("------------------------------------------------");
    }
}

