/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.encoder;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.JsonEncoder;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.jsonTest.JsonLoggingEvent;
import ch.qos.logback.classic.jsonTest.JsonStringToLoggingEventMapper;
import ch.qos.logback.classic.jsonTest.ThrowableProxyComparator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.util.LogbackMDCAdapter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.StatusPrinter;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.IMarkerFactory;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;
import org.slf4j.helpers.BasicMarkerFactory;
import org.slf4j.spi.MDCAdapter;

class JsonEncoderTest {
    int diff = RandomUtil.getPositiveInt();
    LoggerContext loggerContext = new LoggerContext();
    Logger logger = this.loggerContext.getLogger(JsonEncoderTest.class);
    JsonEncoder jsonEncoder = new JsonEncoder();
    BasicMarkerFactory markerFactory = new BasicMarkerFactory();
    Marker markerA = this.markerFactory.getMarker("A");
    Marker markerB = this.markerFactory.getMarker("B");
    ListAppender<ILoggingEvent> listAppender = new ListAppender();
    JsonStringToLoggingEventMapper stringToLoggingEventMapper = new JsonStringToLoggingEventMapper((IMarkerFactory)this.markerFactory);
    LogbackMDCAdapter logbackMDCAdapter = new LogbackMDCAdapter();

    JsonEncoderTest() {
    }

    @BeforeEach
    void setUp() {
        this.loggerContext.setName("test_" + this.diff);
        this.loggerContext.setMDCAdapter((MDCAdapter)this.logbackMDCAdapter);
        this.jsonEncoder.setContext((Context)this.loggerContext);
        this.jsonEncoder.start();
        this.listAppender.setContext((Context)this.loggerContext);
        this.listAppender.start();
    }

    @AfterEach
    void tearDown() {
    }

    @Test
    void smoke() throws JsonProcessingException {
        LoggingEvent event = new LoggingEvent("x", this.logger, Level.WARN, "hello", null, null);
        byte[] resultBytes = this.jsonEncoder.encode((ILoggingEvent)event);
        String resultString = new String(resultBytes, StandardCharsets.UTF_8);
        JsonLoggingEvent resultEvent = this.stringToLoggingEventMapper.mapStringToLoggingEvent(resultString);
        JsonEncoderTest.compareEvents(event, resultEvent);
    }

    @Test
    void contextWithProperties() throws JsonProcessingException {
        this.loggerContext.putProperty("k", "v");
        this.loggerContext.putProperty("k" + this.diff, "v" + this.diff);
        LoggingEvent event = new LoggingEvent("x", this.logger, Level.WARN, "hello", null, null);
        byte[] resultBytes = this.jsonEncoder.encode((ILoggingEvent)event);
        String resultString = new String(resultBytes, StandardCharsets.UTF_8);
        JsonLoggingEvent resultEvent = this.stringToLoggingEventMapper.mapStringToLoggingEvent(resultString);
        JsonEncoderTest.compareEvents(event, resultEvent);
    }

    private static void compareEvents(LoggingEvent event, JsonLoggingEvent resultEvent) {
        Assertions.assertEquals((long)event.getSequenceNumber(), (long)resultEvent.getSequenceNumber());
        Assertions.assertEquals((long)event.getTimeStamp(), (long)resultEvent.getTimeStamp());
        Assertions.assertEquals((Object)event.getLevel(), (Object)resultEvent.getLevel());
        Assertions.assertEquals((Object)event.getLoggerName(), (Object)resultEvent.getLoggerName());
        Assertions.assertEquals((Object)event.getThreadName(), (Object)resultEvent.getThreadName());
        Assertions.assertEquals((Object)event.getMarkerList(), resultEvent.getMarkerList());
        Assertions.assertEquals((Object)event.getMDCPropertyMap(), resultEvent.getMDCPropertyMap());
        Assertions.assertTrue((boolean)JsonEncoderTest.compareKeyValuePairLists(event.getKeyValuePairs(), resultEvent.getKeyValuePairs()));
        Assertions.assertEquals((Object)event.getLoggerContextVO(), (Object)resultEvent.getLoggerContextVO());
        Assertions.assertTrue((boolean)ThrowableProxyComparator.areEqual(event.getThrowableProxy(), resultEvent.getThrowableProxy()));
        Assertions.assertEquals((Object)event.getMessage(), (Object)resultEvent.getMessage());
        Assertions.assertTrue((boolean)Arrays.equals(event.getArgumentArray(), resultEvent.getArgumentArray()));
    }

    private static boolean compareKeyValuePairLists(List<KeyValuePair> leftList, List<KeyValuePair> rightList) {
        if (leftList == rightList) {
            return true;
        }
        if (leftList == null || rightList == null) {
            return false;
        }
        int length = leftList.size();
        if (rightList.size() != length) {
            System.out.println("length discrepancy");
            return false;
        }
        for (int i = 0; i < length; ++i) {
            boolean result;
            KeyValuePair leftKVP = leftList.get(i);
            KeyValuePair rightKVP = rightList.get(i);
            boolean bl = result = Objects.equals(leftKVP.key, rightKVP.key) && Objects.equals(leftKVP.value, rightKVP.value);
            if (result) continue;
            System.out.println("mismatch oin kvp " + leftKVP + " and " + rightKVP);
            return false;
        }
        return true;
    }

    @Test
    void withMarkers() throws JsonProcessingException {
        LoggingEvent event = new LoggingEvent("x", this.logger, Level.WARN, "hello", null, null);
        event.addMarker(this.markerA);
        event.addMarker(this.markerB);
        byte[] resultBytes = this.jsonEncoder.encode((ILoggingEvent)event);
        String resultString = new String(resultBytes, StandardCharsets.UTF_8);
        JsonLoggingEvent resultEvent = this.stringToLoggingEventMapper.mapStringToLoggingEvent(resultString);
        JsonEncoderTest.compareEvents(event, resultEvent);
    }

    @Test
    void withArguments() throws JsonProcessingException {
        LoggingEvent event = new LoggingEvent("x", this.logger, Level.WARN, "hello", null, new Object[]{"arg1", "arg2"});
        byte[] resultBytes = this.jsonEncoder.encode((ILoggingEvent)event);
        String resultString = new String(resultBytes, StandardCharsets.UTF_8);
        JsonLoggingEvent resultEvent = this.stringToLoggingEventMapper.mapStringToLoggingEvent(resultString);
        JsonEncoderTest.compareEvents(event, resultEvent);
    }

    @Test
    void withKeyValuePairs() throws JsonProcessingException {
        LoggingEvent event = new LoggingEvent("x", this.logger, Level.WARN, "hello kvp", null, new Object[]{"arg1", "arg2"});
        event.addKeyValuePair(new KeyValuePair("k1", (Object)"v1"));
        event.addKeyValuePair(new KeyValuePair("k2", (Object)"v2"));
        byte[] resultBytes = this.jsonEncoder.encode((ILoggingEvent)event);
        String resultString = new String(resultBytes, StandardCharsets.UTF_8);
        JsonLoggingEvent resultEvent = this.stringToLoggingEventMapper.mapStringToLoggingEvent(resultString);
        JsonEncoderTest.compareEvents(event, resultEvent);
    }

    @Test
    void withMDC() throws JsonProcessingException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value");
        map.put("a", "b");
        LoggingEvent event = new LoggingEvent("x", this.logger, Level.WARN, "hello kvp", null, new Object[]{"arg1", "arg2"});
        HashMap<String, String> mdcMap = new HashMap<String, String>();
        mdcMap.put("mdcK1", "v1");
        mdcMap.put("mdcK2", "v2");
        event.setMDCPropertyMap(mdcMap);
        byte[] resultBytes = this.jsonEncoder.encode((ILoggingEvent)event);
        String resultString = new String(resultBytes, StandardCharsets.UTF_8);
        JsonLoggingEvent resultEvent = this.stringToLoggingEventMapper.mapStringToLoggingEvent(resultString);
        JsonEncoderTest.compareEvents(event, resultEvent);
    }

    @Test
    void withThrowable() throws JsonProcessingException {
        RuntimeException t = new RuntimeException("test");
        LoggingEvent event = new LoggingEvent("in withThrowable test", this.logger, Level.WARN, "hello kvp", (Throwable)t, null);
        byte[] resultBytes = this.jsonEncoder.encode((ILoggingEvent)event);
        String resultString = new String(resultBytes, StandardCharsets.UTF_8);
        JsonLoggingEvent resultEvent = this.stringToLoggingEventMapper.mapStringToLoggingEvent(resultString);
        JsonEncoderTest.compareEvents(event, resultEvent);
    }

    @Test
    void withThrowableHavingCause() throws JsonProcessingException {
        IllegalStateException cause = new IllegalStateException("test cause");
        RuntimeException t = new RuntimeException("test", cause);
        LoggingEvent event = new LoggingEvent("in withThrowableHavingCause test", this.logger, Level.WARN, "hello kvp", (Throwable)t, null);
        byte[] resultBytes = this.jsonEncoder.encode((ILoggingEvent)event);
        String resultString = new String(resultBytes, StandardCharsets.UTF_8);
        JsonLoggingEvent resultEvent = this.stringToLoggingEventMapper.mapStringToLoggingEvent(resultString);
        JsonEncoderTest.compareEvents(event, resultEvent);
    }

    @Test
    void withThrowableHavingCyclicCause() throws JsonProcessingException {
        IllegalStateException cause = new IllegalStateException("test cause");
        RuntimeException t = new RuntimeException("test", cause);
        cause.initCause(t);
        LoggingEvent event = new LoggingEvent("in withThrowableHavingCyclicCause test", this.logger, Level.WARN, "hello kvp", (Throwable)t, null);
        byte[] resultBytes = this.jsonEncoder.encode((ILoggingEvent)event);
        String resultString = new String(resultBytes, StandardCharsets.UTF_8);
        JsonLoggingEvent resultEvent = this.stringToLoggingEventMapper.mapStringToLoggingEvent(resultString);
        JsonEncoderTest.compareEvents(event, resultEvent);
    }

    @Test
    void withThrowableHavingSuppressed() throws JsonProcessingException {
        IllegalStateException suppressed = new IllegalStateException("test suppressed");
        RuntimeException t = new RuntimeException("test");
        t.addSuppressed(suppressed);
        LoggingEvent event = new LoggingEvent("in withThrowableHavingCause test", this.logger, Level.WARN, "hello kvp", (Throwable)t, null);
        byte[] resultBytes = this.jsonEncoder.encode((ILoggingEvent)event);
        String resultString = new String(resultBytes, StandardCharsets.UTF_8);
        JsonLoggingEvent resultEvent = this.stringToLoggingEventMapper.mapStringToLoggingEvent(resultString);
        JsonEncoderTest.compareEvents(event, resultEvent);
    }

    void configure(String file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.loggerContext);
        this.loggerContext.putProperty("diff", "" + this.diff);
        jc.doConfigure(file);
    }

    @Test
    void withJoran() throws JoranException, IOException {
        String configFilePathStr = "src/test/input/joran/json/jsonEncoder.xml";
        this.configure(configFilePathStr);
        Logger logger = this.loggerContext.getLogger(this.getClass().getName());
        logger.addAppender(this.listAppender);
        logger.debug("hello");
        this.logbackMDCAdapter.put("a1", "v1" + this.diff);
        logger.atInfo().addKeyValue("ik" + this.diff, (Object)("iv" + this.diff)).addKeyValue("a", (Object)"b").log("bla bla \"x\" foobar");
        this.logbackMDCAdapter.put("a2", "v2" + this.diff);
        logger.atWarn().addMarker(this.markerA).setMessage("some warning message").log();
        this.logbackMDCAdapter.remove("a2");
        logger.atError().addKeyValue("ek" + this.diff, (Object)("v" + this.diff)).setCause((Throwable)new RuntimeException("an error")).log("some error occurred");
        StatusPrinter.print((Context)this.loggerContext);
        Path configFilePath = FileSystems.getDefault().getPath("target/test-output/json/test-" + this.diff + ".json", new String[0]);
        List<String> lines = Files.readAllLines(configFilePath);
        int count = 4;
        Assertions.assertEquals((int)count, (int)lines.size());
        for (int i = 0; i < count; ++i) {
            System.out.println("i = " + i);
            LoggingEvent withnessEvent = (LoggingEvent)this.listAppender.list.get(i);
            JsonLoggingEvent resultEvent = this.stringToLoggingEventMapper.mapStringToLoggingEvent(lines.get(i));
            JsonEncoderTest.compareEvents(withnessEvent, resultEvent);
        }
    }
}

