/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran.serializedModel;

import ch.qos.logback.classic.joran.serializedModel.HardenedModelInputStream;
import ch.qos.logback.classic.model.ConfigurationModel;
import ch.qos.logback.classic.model.LoggerModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.net.HardenedObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ModelSerializationTest {
    ByteArrayOutputStream bos;
    ObjectOutputStream oos;
    HardenedObjectInputStream inputStream;

    @BeforeEach
    public void setUp() throws Exception {
        this.bos = new ByteArrayOutputStream();
        this.oos = new ObjectOutputStream(this.bos);
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Test
    public void smoke() throws ClassNotFoundException, IOException {
        ConfigurationModel configurationModel = new ConfigurationModel();
        configurationModel.setTag("configuration");
        configurationModel.setDebugStr("true");
        LoggerModel loggerModel = new LoggerModel();
        loggerModel.setTag("logger");
        loggerModel.setLevel("DEBUG");
        configurationModel.addSubModel((Model)loggerModel);
        Model back = this.writeAndRead((Model)configurationModel);
        Assertions.assertEquals((Object)configurationModel, (Object)back);
    }

    private Model writeAndRead(Model model) throws IOException, ClassNotFoundException {
        this.writeObject(this.oos, model);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.bos.toByteArray());
        this.inputStream = new HardenedModelInputStream((InputStream)bis);
        Model fooBack = (Model)this.inputStream.readObject();
        this.inputStream.close();
        return fooBack;
    }

    private void writeObject(ObjectOutputStream oos, Object o) throws IOException {
        oos.writeObject(o);
        oos.flush();
        oos.close();
    }
}

