/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.jsonTest;

import ch.qos.logback.classic.jsonTest.STEPDeserializer;
import ch.qos.logback.classic.spi.PubThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PubThrowableProxyDeserializer
extends StdDeserializer<PubThrowableProxy> {
    static StackTraceElementProxy[] EMPTY_STEP_ARRAY = new StackTraceElementProxy[0];
    static PubThrowableProxy[] EMPTY_PTP_ARRAY = new PubThrowableProxy[0];

    protected PubThrowableProxyDeserializer() {
        this(null);
    }

    protected PubThrowableProxyDeserializer(Class<?> vc) {
        super(vc);
    }

    public PubThrowableProxy deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        return PubThrowableProxyDeserializer.jsonNodeThrowableProxy(node);
    }

    private static PubThrowableProxy jsonNodeThrowableProxy(JsonNode node) {
        JsonNode classNameJN = node.get("className");
        JsonNode messageJN = node.get("message");
        JsonNode stepArrayJN = node.get("stepArray");
        JsonNode causeJN = node.get("cause");
        JsonNode commonFramesCountJN = node.get("commonFramesCount");
        JsonNode suppressedJN = node.get("suppressed");
        PubThrowableProxy ptp = new PubThrowableProxy();
        ptp.setClassName(classNameJN.textValue());
        ptp.setMessage(messageJN.textValue());
        List<StackTraceElementProxy> stepList = PubThrowableProxyDeserializer.stepNodeToList(stepArrayJN);
        ptp.setStackTraceElementProxyArray(stepList.toArray(EMPTY_STEP_ARRAY));
        if (commonFramesCountJN != null) {
            int commonFramesCount = commonFramesCountJN.asInt();
            ptp.setCommonFramesCount(commonFramesCount);
        }
        if (causeJN != null) {
            PubThrowableProxy cause = PubThrowableProxyDeserializer.jsonNodeThrowableProxy(causeJN);
            ptp.setCause(cause);
        }
        if (suppressedJN != null) {
            List<PubThrowableProxy> ptpList = PubThrowableProxyDeserializer.suppressedNodeToList(suppressedJN);
            System.out.println("iiiiiiiiiiii");
            System.out.println("ptpList=" + ptpList);
            ptp.setSuppressed(ptpList.toArray(EMPTY_PTP_ARRAY));
        }
        System.out.println("xxxxxxxxxxxxx");
        System.out.println(ptp.getSuppressed());
        return ptp;
    }

    private static List<StackTraceElementProxy> stepNodeToList(JsonNode stepArrayJN) {
        ArrayList<StackTraceElementProxy> stepList = new ArrayList<StackTraceElementProxy>();
        for (JsonNode jsonNode : stepArrayJN) {
            StackTraceElementProxy step = STEPDeserializer.jsonNodeToSTEP(jsonNode);
            stepList.add(step);
        }
        return stepList;
    }

    private static List<PubThrowableProxy> suppressedNodeToList(JsonNode ptpArrayJN) {
        ArrayList<PubThrowableProxy> ptpList = new ArrayList<PubThrowableProxy>();
        for (JsonNode jsonNode : ptpArrayJN) {
            PubThrowableProxy ptp = PubThrowableProxyDeserializer.jsonNodeThrowableProxy(jsonNode);
            ptpList.add(ptp);
        }
        return ptpList;
    }
}

