/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.selector;

import ch.qos.logback.classic.selector.ContextJNDISelector;
import ch.qos.logback.classic.selector.servlet.ContextDetachingSCL;
import ch.qos.logback.classic.util.ContextSelectorStaticBinder;
import ch.qos.logback.core.testUtil.MockInitialContext;
import ch.qos.logback.core.testUtil.MockInitialContextFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.LoggerFactory;
import org.slf4j.LoggerFactoryFriend;

@Disabled
public class ContextDetachingSCLTest {
    static String INITIAL_CONTEXT_KEY = "java.naming.factory.initial";
    ContextDetachingSCL contextDetachingSCL;

    @BeforeEach
    public void setUp() throws Exception {
        System.setProperty("logback.ContextSelector", "JNDI");
        this.contextDetachingSCL = new ContextDetachingSCL();
        MockInitialContextFactory.initialize();
        MockInitialContext mic = MockInitialContextFactory.getContext();
        mic.map.put("java:comp/env/logback/context-name", "toto");
        System.setProperty(INITIAL_CONTEXT_KEY, MockInitialContextFactory.class.getName());
        LoggerFactoryFriend.reset();
        LoggerFactory.getLogger(ContextDetachingSCLTest.class);
    }

    @AfterEach
    public void tearDown() throws Exception {
        System.clearProperty(INITIAL_CONTEXT_KEY);
        LoggerFactoryFriend.reset();
    }

    @Test
    public void testDetach() {
        ContextJNDISelector selector = (ContextJNDISelector)ContextSelectorStaticBinder.getSingleton().getContextSelector();
        this.contextDetachingSCL.contextDestroyed(null);
        Assertions.assertEquals((int)0, (int)selector.getCount());
    }

    @Test
    public void testDetachWithMissingContext() {
        MockInitialContext mic = MockInitialContextFactory.getContext();
        mic.map.put("java:comp/env/logback/context-name", "tata");
        ContextJNDISelector selector = (ContextJNDISelector)ContextSelectorStaticBinder.getSingleton().getContextSelector();
        Assertions.assertEquals((Object)"tata", (Object)selector.getLoggerContext().getName());
        mic.map.put("java:comp/env/logback/context-name", "titi");
        Assertions.assertEquals((Object)"titi", (Object)selector.getLoggerContext().getName());
        this.contextDetachingSCL.contextDestroyed(null);
        Assertions.assertEquals((int)2, (int)selector.getCount());
    }
}

