/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.util.EnvUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ThrowableProxyTest {
    StringWriter sw = new StringWriter();
    PrintWriter pw = new PrintWriter(this.sw);

    @BeforeEach
    public void setUp() throws Exception {
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    public void verify(Throwable t) {
        t.printStackTrace(this.pw);
        ThrowableProxy tp = new ThrowableProxy(t);
        String result = ThrowableProxyUtil.asString((IThrowableProxy)tp);
        result = result.replace("common frames omitted", "more");
        String expected = this.sw.toString();
        Assertions.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void smoke() {
        Exception e = new Exception("smoke");
        this.verify(e);
    }

    @Test
    public void nested() {
        Exception w = null;
        try {
            this.someMethod();
        }
        catch (Exception e) {
            w = new Exception("wrapping", e);
        }
        this.verify(w);
    }

    @Test
    public void suppressed() throws InvocationTargetException, IllegalAccessException {
        Exception ex = null;
        try {
            this.someMethod();
        }
        catch (Exception e) {
            Exception fooException = new Exception("Foo");
            Exception barException = new Exception("Bar");
            e.addSuppressed(fooException);
            e.addSuppressed(barException);
            ex = e;
        }
        this.verify(ex);
    }

    @Test
    public void suppressedWithCause() throws InvocationTargetException, IllegalAccessException {
        Exception ex = null;
        try {
            this.someMethod();
        }
        catch (Exception e) {
            ex = new Exception("Wrapper", e);
            Exception fooException = new Exception("Foo");
            Exception barException = new Exception("Bar");
            ex.addSuppressed(fooException);
            e.addSuppressed(barException);
        }
        this.verify(ex);
    }

    @Test
    public void suppressedWithSuppressed() throws Exception {
        Exception ex = null;
        try {
            this.someMethod();
        }
        catch (Exception e) {
            ex = new Exception("Wrapper", e);
            Exception fooException = new Exception("Foo");
            Exception barException = new Exception("Bar");
            barException.addSuppressed(fooException);
            e.addSuppressed(barException);
        }
        this.verify(ex);
    }

    @Test
    public void nullSTE() {
        Exception t = new Exception("someMethodWithNullException"){
            private static final long serialVersionUID = 1L;

            @Override
            public StackTraceElement[] getStackTrace() {
                return null;
            }
        };
        new ThrowableProxy((Throwable)t);
        Exception top = new Exception("top", t);
        new ThrowableProxy((Throwable)top);
    }

    @Test
    public void multiNested() {
        Exception w = null;
        try {
            this.someOtherMethod();
        }
        catch (Exception e) {
            w = new Exception("wrapping", e);
        }
        this.verify(w);
    }

    @Test
    public void cyclicCause() {
        if (!EnvUtil.isJDK16OrHigher()) {
            return;
        }
        Exception e = new Exception("foo");
        Exception e2 = new Exception(e);
        e.initCause(e2);
        this.verify(e);
    }

    @Test
    public void cyclicSuppressed() {
        if (!EnvUtil.isJDK16OrHigher()) {
            return;
        }
        Exception e = new Exception("foo");
        Exception e2 = new Exception(e);
        e.addSuppressed(e2);
        this.verify(e);
    }

    void someMethod() throws Exception {
        throw new Exception("someMethod");
    }

    void someMethodWithNullException() throws Exception {
        throw new Exception("someMethodWithNullException"){
            private static final long serialVersionUID = -2419053636101615373L;

            @Override
            public StackTraceElement[] getStackTrace() {
                return null;
            }
        };
    }

    void someOtherMethod() throws Exception {
        try {
            this.someMethod();
        }
        catch (Exception e) {
            throw new Exception("someOtherMethod", e);
        }
    }
}

