/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.net.SMTPAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.spi.CyclicBufferTracker;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DilutedSMTPAppenderTest {
    SMTPAppender appender;
    CyclicBufferTracker<ILoggingEvent> cbTracker;
    CyclicBuffer<ILoggingEvent> cb;

    @BeforeEach
    public void setUp() throws Exception {
        LoggerContext lc = new LoggerContext();
        this.appender = new SMTPAppender();
        this.appender.setContext((Context)lc);
        this.appender.setName("smtp");
        this.appender.setFrom("user@host.dom");
        this.appender.setLayout(DilutedSMTPAppenderTest.buildLayout(lc));
        this.appender.setSMTPHost("mail2.qos.ch");
        this.appender.setSubject("logging report");
        this.appender.addTo("sebastien.nospam@qos.ch");
        this.appender.start();
        this.cbTracker = this.appender.getCyclicBufferTracker();
        this.cb = (CyclicBuffer)this.cbTracker.getOrCreate("", 0L);
    }

    private static Layout<ILoggingEvent> buildLayout(LoggerContext lc) {
        PatternLayout layout = new PatternLayout();
        layout.setContext((Context)lc);
        layout.setFileHeader("Some header\n");
        layout.setPattern("%-4relative [%thread] %-5level %class - %msg%n");
        layout.setFileFooter("Some footer");
        layout.start();
        return layout;
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.appender = null;
    }

    @Test
    public void testStart() {
        Assertions.assertEquals((Object)"sebastien.nospam@qos.ch%nopex", this.appender.getToAsListOfString().get(0));
        Assertions.assertEquals((Object)"logging report", (Object)this.appender.getSubject());
        Assertions.assertTrue((boolean)this.appender.isStarted());
    }

    @Test
    public void testAppendNonTriggeringEvent() {
        LoggingEvent event = new LoggingEvent();
        event.setThreadName("thead name");
        event.setLevel(Level.DEBUG);
        this.appender.subAppend(this.cb, (ILoggingEvent)event);
        Assertions.assertEquals((int)1, (int)this.cb.length());
    }

    @Test
    public void testEntryConditionsCheck() {
        this.appender.checkEntryConditions();
        Assertions.assertEquals((int)0, (int)this.appender.getContext().getStatusManager().getCount());
    }

    @Test
    public void testTriggeringPolicy() {
        this.appender.setEvaluator(null);
        this.appender.checkEntryConditions();
        Assertions.assertEquals((int)1, (int)this.appender.getContext().getStatusManager().getCount());
    }

    @Test
    public void testEntryConditionsCheckNoLayout() {
        this.appender.setLayout(null);
        this.appender.checkEntryConditions();
        Assertions.assertEquals((int)1, (int)this.appender.getContext().getStatusManager().getCount());
    }
}

