/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.html.HTMLLayout;
import ch.qos.logback.classic.html.XHTMLEntityResolver;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.net.SMTPAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.StatusListenerConfigHelper;
import ch.qos.logback.core.util.StatusPrinter;
import com.icegreen.greenmail.util.DummySSLSocketFactory;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.icegreen.greenmail.util.ServerSetup;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.MDC;
import org.xml.sax.EntityResolver;

public class SMTPAppender_GreenTest {
    static boolean NO_SSL = false;
    static boolean WITH_SSL = true;
    static final String HEADER = "HEADER\n";
    static final String FOOTER = "FOOTER\n";
    static final String DEFAULT_PATTERN = "%-4relative %mdc [%thread] %-5level %class - %msg%n";
    static final boolean SYNCHRONOUS = false;
    static final boolean ASYNCHRONOUS = true;
    int port = RandomUtil.getRandomServerPort();
    GreenMail greenMailServer;
    SMTPAppender smtpAppender;
    LoggerContext loggerContext = new LoggerContext();
    Logger logger = this.loggerContext.getLogger(this.getClass());
    static String REQUIRED_USERNAME = "alice";
    static String REQUIRED_PASSWORD = "alicepass";
    static String GMAIL_USER_NAME = "xx@gmail.com";
    static String GMAIL_PASSWORD = "xxx";

    @BeforeEach
    public void setUp() throws Exception {
        StatusListenerConfigHelper.addOnConsoleListenerInstance((Context)this.loggerContext, (OnConsoleStatusListener)new OnConsoleStatusListener());
        MDC.clear();
    }

    void startSMTPServer(boolean withSSL) {
        ServerSetup serverSetup = withSSL ? new ServerSetup(this.port, null, "smtps") : new ServerSetup(this.port, null, "smtp");
        this.greenMailServer = new GreenMail(serverSetup);
        this.greenMailServer.setUser(REQUIRED_USERNAME, REQUIRED_PASSWORD);
        this.greenMailServer.start();
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.greenMailServer.stop();
    }

    void buildSMTPAppender(String subject, boolean synchronicity) throws Exception {
        this.smtpAppender = new SMTPAppender();
        this.smtpAppender.setContext((Context)this.loggerContext);
        this.smtpAppender.setName("smtp");
        this.smtpAppender.setFrom("user@host.dom");
        this.smtpAppender.setSMTPHost("localhost");
        this.smtpAppender.setSMTPPort(this.port);
        this.smtpAppender.setSubject(subject);
        this.smtpAppender.addTo("nospam@qos.ch");
        this.smtpAppender.setAsynchronousSending(synchronicity);
    }

    private Layout<ILoggingEvent> buildPatternLayout(String pattern) {
        PatternLayout layout = new PatternLayout();
        layout.setContext((Context)this.loggerContext);
        layout.setFileHeader(HEADER);
        layout.setOutputPatternAsHeader(false);
        layout.setPattern(pattern);
        layout.setFileFooter(FOOTER);
        layout.start();
        return layout;
    }

    private Layout<ILoggingEvent> buildHTMLLayout() {
        HTMLLayout layout = new HTMLLayout();
        layout.setContext((Context)this.loggerContext);
        layout.setPattern("%level%class%msg");
        layout.start();
        return layout;
    }

    private void waitForServerToReceiveEmails(int emailCount) throws InterruptedException {
        this.greenMailServer.waitForIncomingEmail(5000L, emailCount);
    }

    private MimeMultipart verifyAndExtractMimeMultipart(String subject) throws MessagingException, IOException, InterruptedException {
        int oldCount = 0;
        int expectedEmailCount = 1;
        this.waitForServerToReceiveEmails(expectedEmailCount);
        MimeMessage[] mma = this.greenMailServer.getReceivedMessages();
        Assertions.assertNotNull((Object)mma);
        Assertions.assertEquals((int)expectedEmailCount, (int)mma.length);
        MimeMessage mm = mma[oldCount];
        Assertions.assertEquals((Object)subject, (Object)mm.getSubject());
        return (MimeMultipart)mm.getContent();
    }

    void waitUntilEmailIsSent() throws InterruptedException {
        this.loggerContext.getScheduledExecutorService().shutdown();
        this.loggerContext.getScheduledExecutorService().awaitTermination(1000L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void synchronousSmoke() throws Exception {
        this.startSMTPServer(NO_SSL);
        String subject = "synchronousSmoke";
        this.buildSMTPAppender(subject, false);
        this.smtpAppender.setLayout(this.buildPatternLayout(DEFAULT_PATTERN));
        this.smtpAppender.start();
        this.logger.addAppender((Appender)this.smtpAppender);
        this.logger.debug("hello");
        this.logger.error("en error", (Throwable)new Exception("an exception"));
        MimeMultipart mp = this.verifyAndExtractMimeMultipart(subject);
        String body = GreenMailUtil.getBody((Part)mp.getBodyPart(0));
        Assertions.assertTrue((boolean)body.startsWith(HEADER.trim()));
        Assertions.assertTrue((boolean)body.endsWith(FOOTER.trim()));
    }

    @Test
    public void asynchronousSmoke() throws Exception {
        this.startSMTPServer(NO_SSL);
        String subject = "asynchronousSmoke";
        this.buildSMTPAppender(subject, true);
        this.smtpAppender.setLayout(this.buildPatternLayout(DEFAULT_PATTERN));
        this.smtpAppender.start();
        this.logger.addAppender((Appender)this.smtpAppender);
        this.logger.debug("hello");
        this.logger.error("en error", (Throwable)new Exception("an exception"));
        this.waitUntilEmailIsSent();
        MimeMultipart mp = this.verifyAndExtractMimeMultipart(subject);
        String body = GreenMailUtil.getBody((Part)mp.getBodyPart(0));
        Assertions.assertTrue((boolean)body.startsWith(HEADER.trim()));
        Assertions.assertTrue((boolean)body.endsWith(FOOTER.trim()));
    }

    @Test
    public void callerDataShouldBeCorrectlySetWithAsynchronousSending() throws Exception {
        this.startSMTPServer(NO_SSL);
        String subject = "LOGBACK-734";
        this.buildSMTPAppender("LOGBACK-734", true);
        this.smtpAppender.setLayout(this.buildPatternLayout(DEFAULT_PATTERN));
        this.smtpAppender.setIncludeCallerData(true);
        this.smtpAppender.start();
        this.logger.addAppender((Appender)this.smtpAppender);
        this.logger.debug("LOGBACK-734");
        this.logger.error("callerData", (Throwable)new Exception("ShouldBeCorrectlySetWithAsynchronousSending"));
        this.waitUntilEmailIsSent();
        MimeMultipart mp = this.verifyAndExtractMimeMultipart(subject);
        String body = GreenMailUtil.getBody((Part)mp.getBodyPart(0));
        Assertions.assertTrue((boolean)body.contains("DEBUG " + this.getClass().getName() + " - LOGBACK-734"), (String)("actual [" + body + "]"));
    }

    @Test
    public void LOGBACK_352() throws Exception {
        this.startSMTPServer(NO_SSL);
        String subject = "LOGBACK_352";
        this.buildSMTPAppender(subject, false);
        this.smtpAppender.setAsynchronousSending(false);
        this.smtpAppender.setLayout(this.buildPatternLayout(DEFAULT_PATTERN));
        this.smtpAppender.start();
        this.logger.addAppender((Appender)this.smtpAppender);
        MDC.put((String)"key", (String)"val");
        this.logger.debug("LBCLASSIC_104");
        MDC.clear();
        this.logger.error("en error", (Throwable)new Exception("test"));
        MimeMultipart mp = this.verifyAndExtractMimeMultipart(subject);
        String body = GreenMailUtil.getBody((Part)mp.getBodyPart(0));
        Assertions.assertTrue((boolean)body.startsWith(HEADER.trim()));
        System.out.println(body);
        Assertions.assertTrue((boolean)body.contains("key=val"));
        Assertions.assertTrue((boolean)body.endsWith(FOOTER.trim()));
    }

    @Test
    public void html() throws Exception {
        this.startSMTPServer(NO_SSL);
        String subject = "html";
        this.buildSMTPAppender(subject, false);
        this.smtpAppender.setAsynchronousSending(false);
        this.smtpAppender.setLayout(this.buildHTMLLayout());
        this.smtpAppender.start();
        this.logger.addAppender((Appender)this.smtpAppender);
        this.logger.debug("html");
        this.logger.error("en error", (Throwable)new Exception("an exception"));
        MimeMultipart mp = this.verifyAndExtractMimeMultipart(subject);
        SAXReader reader = new SAXReader();
        reader.setValidation(true);
        reader.setEntityResolver((EntityResolver)new XHTMLEntityResolver());
        byte[] messageBytes = this.getAsByteArray(mp.getBodyPart(0).getInputStream());
        ByteArrayInputStream bais = new ByteArrayInputStream(messageBytes);
        try {
            reader.read((InputStream)bais);
        }
        catch (DocumentException de) {
            System.out.println("incoming message:");
            System.out.println(new String(messageBytes));
            throw de;
        }
        System.out.println("incoming message:");
        System.out.println(new String(messageBytes));
    }

    private byte[] getAsByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int n = -1;
        while ((n = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, n);
        }
        return baos.toByteArray();
    }

    private void configure(String file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.loggerContext);
        this.loggerContext.putProperty("port", "" + this.port);
        jc.doConfigure(file);
    }

    @Test
    public void testCustomEvaluator() throws Exception {
        this.startSMTPServer(NO_SSL);
        this.configure("src/test/input/joran/smtp/customEvaluator.xml");
        this.logger.debug("test");
        String msg2 = "CustomEvaluator";
        this.logger.debug(msg2);
        this.logger.debug("invisible");
        this.waitUntilEmailIsSent();
        MimeMultipart mp = this.verifyAndExtractMimeMultipart("testCustomEvaluator " + this.getClass().getName() + " - " + msg2);
        String body = GreenMailUtil.getBody((Part)mp.getBodyPart(0));
        Assertions.assertEquals((Object)"testCustomEvaluator", (Object)body);
    }

    @Test
    public void testCustomBufferSize() throws Exception {
        this.startSMTPServer(NO_SSL);
        this.configure("src/test/input/joran/smtp/customBufferSize.xml");
        this.logger.debug("invisible1");
        this.logger.debug("invisible2");
        String msg = "hello";
        this.logger.error(msg);
        this.waitUntilEmailIsSent();
        MimeMultipart mp = this.verifyAndExtractMimeMultipart("testCustomBufferSize " + this.getClass().getName() + " - " + msg);
        String body = GreenMailUtil.getBody((Part)mp.getBodyPart(0));
        Assertions.assertEquals((Object)msg, (Object)body);
    }

    @Test
    public void testMultipleTo() throws Exception {
        this.startSMTPServer(NO_SSL);
        this.buildSMTPAppender("testMultipleTo", false);
        this.smtpAppender.setLayout(this.buildPatternLayout(DEFAULT_PATTERN));
        this.smtpAppender.addTo("Test <test@example.com>, other-test@example.com");
        this.smtpAppender.start();
        this.logger.addAppender((Appender)this.smtpAppender);
        this.logger.debug("testMultipleTo hello");
        this.logger.error("testMultipleTo en error", (Throwable)new Exception("an exception"));
        Thread.yield();
        int expectedEmailCount = 3;
        this.waitForServerToReceiveEmails(expectedEmailCount);
        MimeMessage[] mma = this.greenMailServer.getReceivedMessages();
        Assertions.assertNotNull((Object)mma);
        Assertions.assertEquals((int)expectedEmailCount, (int)mma.length);
    }

    @Test
    public void bufferShouldBeResetBetweenMessages() throws Exception {
        this.startSMTPServer(NO_SSL);
        this.buildSMTPAppender("bufferShouldBeResetBetweenMessages", false);
        this.smtpAppender.setLayout(this.buildPatternLayout(DEFAULT_PATTERN));
        this.smtpAppender.start();
        this.logger.addAppender((Appender)this.smtpAppender);
        String msg0 = "hello zero";
        this.logger.debug(msg0);
        this.logger.error("error zero");
        String msg1 = "hello one";
        this.logger.debug(msg1);
        this.logger.error("error one");
        Thread.yield();
        int oldCount = 0;
        int expectedEmailCount = oldCount + 2;
        this.waitForServerToReceiveEmails(expectedEmailCount);
        MimeMessage[] mma = this.greenMailServer.getReceivedMessages();
        Assertions.assertNotNull((Object)mma);
        Assertions.assertEquals((int)expectedEmailCount, (int)mma.length);
        MimeMessage mm0 = mma[oldCount];
        MimeMultipart content0 = (MimeMultipart)mm0.getContent();
        String body0 = GreenMailUtil.getBody((Part)content0.getBodyPart(0));
        MimeMessage mm1 = mma[oldCount + 1];
        MimeMultipart content1 = (MimeMultipart)mm1.getContent();
        String body1 = GreenMailUtil.getBody((Part)content1.getBodyPart(0));
        Assertions.assertFalse((boolean)body1.contains(msg0));
    }

    @Test
    public void multiLineSubjectTruncatedAtFirstNewLine() throws Exception {
        this.startSMTPServer(NO_SSL);
        String line1 = "line 1 of subject";
        String subject = line1 + "\nline 2 of subject\n";
        this.buildSMTPAppender(subject, true);
        this.smtpAppender.setLayout(this.buildPatternLayout(DEFAULT_PATTERN));
        this.smtpAppender.start();
        this.logger.addAppender((Appender)this.smtpAppender);
        this.logger.debug("hello");
        this.logger.error("en error", (Throwable)new Exception("an exception"));
        Thread.yield();
        this.waitUntilEmailIsSent();
        this.waitForServerToReceiveEmails(1);
        MimeMessage[] mma = this.greenMailServer.getReceivedMessages();
        Assertions.assertEquals((int)1, (int)mma.length);
        Assertions.assertEquals((Object)line1, (Object)mma[0].getSubject());
    }

    @Test
    public void authenticated() throws Exception {
        this.startSMTPServer(NO_SSL);
        this.buildSMTPAppender("testMultipleTo", false);
        this.smtpAppender.setUsername(REQUIRED_USERNAME);
        this.smtpAppender.setPassword(REQUIRED_PASSWORD);
        this.smtpAppender.setLayout(this.buildPatternLayout(DEFAULT_PATTERN));
        this.smtpAppender.start();
        this.logger.addAppender((Appender)this.smtpAppender);
        this.logger.debug("authenticated");
        this.logger.error("authenticated en error", (Throwable)new Exception("an exception"));
        this.waitUntilEmailIsSent();
        this.waitForServerToReceiveEmails(1);
        MimeMessage[] mma = this.greenMailServer.getReceivedMessages();
        Assertions.assertNotNull((Object)mma);
        Assertions.assertTrue((mma.length == 1 ? 1 : 0) != 0, (String)"body should not be empty");
    }

    void setSystemPropertiesForStartTLS() {
        String PREFIX = "mail.smtp.";
        System.setProperty(PREFIX + "starttls.enable", "true");
        System.setProperty(PREFIX + "socketFactory.class", DummySSLSocketFactory.class.getName());
        System.setProperty(PREFIX + "socketFactory.fallback", "false");
    }

    void unsetSystemPropertiesForStartTLS() {
        String PREFIX = "mail.smtp.";
        System.clearProperty(PREFIX + "starttls.enable");
        System.clearProperty(PREFIX + "socketFactory.class");
        System.clearProperty(PREFIX + "socketFactory.fallback");
    }

    @Disabled
    @Test
    public void authenticatedSSL() throws Exception {
        try {
            this.setSystemPropertiesForStartTLS();
            this.startSMTPServer(WITH_SSL);
            this.buildSMTPAppender("testMultipleTo", false);
            this.smtpAppender.setUsername(REQUIRED_USERNAME);
            this.smtpAppender.setPassword(REQUIRED_PASSWORD);
            this.smtpAppender.setSTARTTLS(true);
            this.smtpAppender.setLayout(this.buildPatternLayout(DEFAULT_PATTERN));
            this.smtpAppender.start();
            this.logger.addAppender((Appender)this.smtpAppender);
            this.logger.debug("authenticated");
            this.logger.error("authenticated en error", (Throwable)new Exception("an exception"));
            this.waitUntilEmailIsSent();
            this.waitForServerToReceiveEmails(1);
            MimeMessage[] mma = this.greenMailServer.getReceivedMessages();
            Assertions.assertNotNull((Object)mma);
            Assertions.assertTrue((mma.length == 1 ? 1 : 0) != 0, (String)"body should not be empty");
        }
        finally {
            this.unsetSystemPropertiesForStartTLS();
        }
    }

    @Disabled
    @Test
    public void authenticatedGmailStartTLS() throws Exception {
        this.smtpAppender.setSMTPHost("smtp.gmail.com");
        this.smtpAppender.setSMTPPort(587);
        this.smtpAppender.setAsynchronousSending(false);
        this.smtpAppender.addTo(GMAIL_USER_NAME);
        this.smtpAppender.setSTARTTLS(true);
        this.smtpAppender.setUsername(GMAIL_USER_NAME);
        this.smtpAppender.setPassword(GMAIL_PASSWORD);
        this.smtpAppender.setLayout(this.buildPatternLayout(DEFAULT_PATTERN));
        this.smtpAppender.setSubject("authenticatedGmailStartTLS - %level %logger{20} - %m");
        this.smtpAppender.start();
        Logger logger = this.loggerContext.getLogger("authenticatedGmailSTARTTLS");
        logger.addAppender((Appender)this.smtpAppender);
        logger.debug("authenticatedGmailStartTLS =- hello");
        logger.error("en error", (Throwable)new Exception("an exception"));
        StatusPrinter.print((Context)this.loggerContext);
    }

    @Disabled
    @Test
    public void authenticatedGmail_SSL() throws Exception {
        this.smtpAppender.setSMTPHost("smtp.gmail.com");
        this.smtpAppender.setSMTPPort(465);
        this.smtpAppender.setSubject("authenticatedGmail_SSL - %level %logger{20} - %m");
        this.smtpAppender.addTo(GMAIL_USER_NAME);
        this.smtpAppender.setSSL(true);
        this.smtpAppender.setUsername(GMAIL_USER_NAME);
        this.smtpAppender.setPassword(GMAIL_PASSWORD);
        this.smtpAppender.setAsynchronousSending(false);
        this.smtpAppender.setLayout(this.buildPatternLayout(DEFAULT_PATTERN));
        this.smtpAppender.start();
        Logger logger = this.loggerContext.getLogger("authenticatedGmail_SSL");
        logger.addAppender((Appender)this.smtpAppender);
        logger.debug("hello" + new Date());
        logger.error("en error", (Throwable)new Exception("an exception"));
        StatusPrinter.print((Context)this.loggerContext);
    }
}

