/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.NoFilter;
import ch.qos.logback.classic.YesFilter;
import ch.qos.logback.classic.turbo.MarkerFilter;
import ch.qos.logback.classic.turbo.TurboFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class TurboFilteringInLoggerTest {
    static final String BLUE = "BLUE";
    LoggerContext context;
    Logger logger;
    Marker blueMarker = MarkerFactory.getMarker((String)"BLUE");

    @BeforeEach
    public void setUp() throws Exception {
        this.context = new LoggerContext();
        this.context.setName("test");
        this.context.start();
        this.logger = this.context.getLogger(TurboFilteringInLoggerTest.class);
    }

    private void addYesFilter() {
        YesFilter filter = new YesFilter();
        filter.start();
        this.context.addTurboFilter((TurboFilter)filter);
    }

    private void addNoFilter() {
        NoFilter filter = new NoFilter();
        filter.start();
        this.context.addTurboFilter((TurboFilter)filter);
    }

    private void addAcceptBLUEFilter() {
        MarkerFilter filter = new MarkerFilter();
        filter.setMarker(BLUE);
        filter.setOnMatch("ACCEPT");
        filter.start();
        this.context.addTurboFilter((TurboFilter)filter);
    }

    private void addDenyBLUEFilter() {
        MarkerFilter filter = new MarkerFilter();
        filter.setMarker(BLUE);
        filter.setOnMatch("DENY");
        filter.start();
        this.context.addTurboFilter((TurboFilter)filter);
    }

    @Test
    public void testIsDebugEnabledWithYesFilter() {
        this.addYesFilter();
        this.logger.setLevel(Level.INFO);
        Assertions.assertTrue((boolean)this.logger.isDebugEnabled());
    }

    @Test
    public void testIsInfoEnabledWithYesFilter() {
        this.addYesFilter();
        this.logger.setLevel(Level.WARN);
        Assertions.assertTrue((boolean)this.logger.isInfoEnabled());
    }

    @Test
    public void testIsWarnEnabledWithYesFilter() {
        this.addYesFilter();
        this.logger.setLevel(Level.ERROR);
        Assertions.assertTrue((boolean)this.logger.isWarnEnabled());
    }

    @Test
    public void testIsErrorEnabledWithYesFilter() {
        this.addYesFilter();
        this.logger.setLevel(Level.OFF);
        Assertions.assertTrue((boolean)this.logger.isErrorEnabled());
    }

    @Test
    public void testIsEnabledForWithYesFilter() {
        this.addYesFilter();
        this.logger.setLevel(Level.ERROR);
        Assertions.assertTrue((boolean)this.logger.isEnabledFor(Level.INFO));
    }

    @Test
    public void testIsEnabledForWithNoFilter() {
        this.addNoFilter();
        this.logger.setLevel(Level.DEBUG);
        Assertions.assertFalse((boolean)this.logger.isEnabledFor(Level.INFO));
    }

    @Test
    public void testIsDebugEnabledWithNoFilter() {
        this.addNoFilter();
        this.logger.setLevel(Level.DEBUG);
        Assertions.assertFalse((boolean)this.logger.isDebugEnabled());
    }

    @Test
    public void testIsInfoEnabledWithNoFilter() {
        this.addNoFilter();
        this.logger.setLevel(Level.DEBUG);
        Assertions.assertFalse((boolean)this.logger.isInfoEnabled());
    }

    @Test
    public void testIsWarnEnabledWithNoFilter() {
        this.addNoFilter();
        this.logger.setLevel(Level.DEBUG);
        Assertions.assertFalse((boolean)this.logger.isWarnEnabled());
    }

    @Test
    public void testIsErrorEnabledWithNoFilter() {
        this.addNoFilter();
        this.logger.setLevel(Level.DEBUG);
        Assertions.assertFalse((boolean)this.logger.isErrorEnabled());
    }

    @Test
    public void testIsErrorEnabledWithAcceptBlueFilter() {
        this.addAcceptBLUEFilter();
        this.logger.setLevel(Level.ERROR);
        Assertions.assertTrue((boolean)this.logger.isDebugEnabled(this.blueMarker));
    }

    @Test
    public void testIsErrorEnabledWithDenyBlueFilter() {
        this.addDenyBLUEFilter();
        this.logger.setLevel(Level.ALL);
        Assertions.assertFalse((boolean)this.logger.isDebugEnabled(this.blueMarker));
    }

    @Test
    public void testLoggingContextReset() {
        this.addYesFilter();
        Assertions.assertNotNull((Object)this.context.getTurboFilterList().get(0));
        this.context.reset();
        Assertions.assertEquals((int)0, (int)this.context.getTurboFilterList().size());
    }
}

