/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.boolex.JaninoEventEvaluator;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.joran.spi.JoranException;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@Disabled
public class EvaluatorJoranTest {
    @Test
    public void testSimpleEvaluator() throws NullPointerException, EvaluationException, JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        LoggerContext loggerContext = new LoggerContext();
        jc.setContext((Context)loggerContext);
        jc.doConfigure("src/test/input/joran/simpleEvaluator.xml");
        Map evalMap = (Map)loggerContext.getObject("EVALUATOR_MAP");
        Assertions.assertNotNull((Object)evalMap);
        JaninoEventEvaluator evaluator = (JaninoEventEvaluator)evalMap.get("msgEval");
        Assertions.assertNotNull((Object)evaluator);
        Logger logger = loggerContext.getLogger("xx");
        LoggingEvent event0 = new LoggingEvent("foo", logger, Level.DEBUG, "Hello world", null, null);
        Assertions.assertTrue((boolean)evaluator.evaluate((Object)event0));
        LoggingEvent event1 = new LoggingEvent("foo", logger, Level.DEBUG, "random blurb", null, null);
        Assertions.assertFalse((boolean)evaluator.evaluate((Object)event1));
    }

    @Disabled
    @Test
    public void testIgnoreMarker() throws NullPointerException, EvaluationException, JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        LoggerContext loggerContext = new LoggerContext();
        jc.setContext((Context)loggerContext);
        jc.doConfigure("src/test/input/joran/ignore.xml");
        Map evalMap = (Map)loggerContext.getObject("EVALUATOR_MAP");
        Assertions.assertNotNull((Object)evalMap);
        Logger logger = loggerContext.getLogger("xx");
        JaninoEventEvaluator evaluator = (JaninoEventEvaluator)evalMap.get("IGNORE_EVAL");
        LoggingEvent event = new LoggingEvent("foo", logger, Level.DEBUG, "Hello world", null, null);
        Marker ignoreMarker = MarkerFactory.getMarker((String)"IGNORE");
        event.addMarker(ignoreMarker);
        Assertions.assertTrue((boolean)evaluator.evaluate((Object)event));
        logger.debug("hello", (Throwable)new Exception("test"));
        logger.debug(ignoreMarker, "hello ignore", (Throwable)new Exception("test"));
    }

    @Test
    public void testMultipleConditionsInExpression() throws NullPointerException, EvaluationException {
        LoggerContext loggerContext = new LoggerContext();
        Logger logger = loggerContext.getLogger("xx");
        JaninoEventEvaluator ee = new JaninoEventEvaluator();
        ee.setName("testEval");
        ee.setContext((Context)loggerContext);
        ee.setExpression("message.contains(\"stacktrace\") && message.contains(\"logging\")");
        ee.start();
        String message = "stacktrace bla bla logging";
        LoggingEvent event = new LoggingEvent(this.getClass().getName(), logger, Level.DEBUG, message, null, null);
        Assertions.assertTrue((boolean)ee.evaluate((Object)event));
    }
}

