/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.issue.lbclassic135.LoggingRunnable;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.joran.ReconfigureOnChangeTask;
import ch.qos.logback.classic.joran.ReconfigureOnChangeTaskListener;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.contention.AbstractMultiThreadedHarness;
import ch.qos.logback.core.contention.RunnableWithCounterAndDone;
import ch.qos.logback.core.joran.spi.ConfigurationWatchList;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import ch.qos.logback.core.testUtil.FileTestUtil;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class ReconfigureOnChangeTaskTest {
    static final int THREAD_COUNT = 5;
    int diff = RandomUtil.getPositiveInt();
    static final String SCAN1_FILE_AS_STR = "src/test/input/joran/roct/scan 1.xml";
    static final String G_SCAN1_FILE_AS_STR = "src/test/input/joran/roct/scan 1.groovy";
    static final String SCAN_LOGBACK_474_FILE_AS_STR = "src/test/input/joran/roct/scan_logback_474.xml";
    static final String INCLUSION_SCAN_TOPLEVEL0_AS_STR = "src/test/input/joran/roct/inclusion/topLevel0.xml";
    static final String INCLUSION_SCAN_TOP_BY_RESOURCE_AS_STR = "src/test/input/joran/roct/inclusion/topByResource.xml";
    static final String INCLUSION_SCAN_INNER0_AS_STR = "src/test/input/joran/roct/inclusion/inner0.xml";
    static final String INCLUSION_SCAN_INNER1_AS_STR = "target/test-classes/asResource/inner1.xml";
    private static final String SCAN_PERIOD_DEFAULT_FILE_AS_STR = "src/test/input/joran/roct/scan_period_default.xml";
    LoggerContext loggerContext = new LoggerContext();
    Logger logger = this.loggerContext.getLogger(this.getClass());
    StatusChecker statusChecker = new StatusChecker((Context)this.loggerContext);

    @BeforeAll
    public static void classSetup() {
        FileTestUtil.makeTestOutputDir();
    }

    void configure(File file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.loggerContext);
        jc.doConfigure(file);
    }

    void configure(InputStream is) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.loggerContext);
        jc.doConfigure(is);
    }

    @BeforeEach
    public void before() {
        System.out.println(this.getClass().getName() + "#before");
    }

    @Test
    @Timeout(value=4L, unit=TimeUnit.SECONDS)
    public void checkBasicLifecyle() throws JoranException, IOException, InterruptedException {
        File file = new File(SCAN1_FILE_AS_STR);
        this.configure(file);
        List<File> fileList = this.getConfigurationWatchList(this.loggerContext);
        this.assertThatListContainsFile(fileList, file);
        this.checkThatTaskHasRan();
        this.checkThatTaskCanBeStopped();
    }

    private void checkThatTaskCanBeStopped() {
        ScheduledFuture future = (ScheduledFuture)this.loggerContext.getCopyOfScheduledFutures().get(0);
        this.loggerContext.stop();
        Assertions.assertTrue((boolean)future.isCancelled());
    }

    private void checkThatTaskHasRan() throws InterruptedException {
        this.waitForReconfigureOnChangeTaskToRun();
    }

    List<File> getConfigurationWatchList(LoggerContext context) {
        ConfigurationWatchList configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList((Context)this.loggerContext);
        return configurationWatchList.getCopyOfFileWatchList();
    }

    @Test
    @Timeout(value=4L, unit=TimeUnit.SECONDS)
    public void scanWithFileInclusion() throws JoranException, IOException, InterruptedException {
        File topLevelFile = new File(INCLUSION_SCAN_TOPLEVEL0_AS_STR);
        File innerFile = new File(INCLUSION_SCAN_INNER0_AS_STR);
        this.configure(topLevelFile);
        List<File> fileList = this.getConfigurationWatchList(this.loggerContext);
        this.assertThatListContainsFile(fileList, topLevelFile);
        this.assertThatListContainsFile(fileList, innerFile);
        this.checkThatTaskHasRan();
        this.checkThatTaskCanBeStopped();
    }

    @Test
    @Timeout(value=4L, unit=TimeUnit.SECONDS)
    public void scanWithResourceInclusion() throws JoranException, IOException, InterruptedException {
        File topLevelFile = new File(INCLUSION_SCAN_TOP_BY_RESOURCE_AS_STR);
        File innerFile = new File(INCLUSION_SCAN_INNER1_AS_STR);
        this.configure(topLevelFile);
        List<File> fileList = this.getConfigurationWatchList(this.loggerContext);
        this.assertThatListContainsFile(fileList, topLevelFile);
        this.assertThatListContainsFile(fileList, innerFile);
    }

    @Test
    @Timeout(value=4L, unit=TimeUnit.SECONDS)
    public void reconfigurationIsNotPossibleInTheAbsenceOfATopFile() throws IOException, JoranException, InterruptedException {
        String configurationStr = "<configuration scan=\"true\" scanPeriod=\"50 millisecond\"><include resource=\"asResource/inner1.xml\"/></configuration>";
        this.configure(new ByteArrayInputStream(configurationStr.getBytes("UTF-8")));
        ConfigurationWatchList configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList((Context)this.loggerContext);
        Assertions.assertNull((Object)configurationWatchList);
        this.statusChecker.containsMatch(1, "Due to missing top level");
        StatusPrinter.print((Context)this.loggerContext);
        ReconfigureOnChangeTask roct = this.getRegisteredReconfigureTask();
        Assertions.assertNull((Object)roct);
        Assertions.assertEquals((int)0, (int)this.loggerContext.getCopyOfScheduledFutures().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=3L, unit=TimeUnit.SECONDS)
    public void fallbackToSafe_FollowedByRecovery() throws IOException, JoranException, InterruptedException {
        String path = "target/test-output/reconfigureOnChangeConfig_fallbackToSafe-" + this.diff + ".xml";
        File topLevelFile = new File(path);
        this.writeToFile(topLevelFile, "<configuration scan=\"true\" scanPeriod=\"5 millisecond\"><root level=\"ERROR\"/></configuration> ");
        this.configure(topLevelFile);
        StatusPrinter.print((Context)this.loggerContext);
        CountDownLatch changeDetectedLatch = this.registerNewReconfigurationDoneListener_WithNewROCT(null);
        ReconfigureOnChangeTask oldRoct = this.getRegisteredReconfigureTask();
        this.addInfo("registered ReconfigureOnChangeTask ", oldRoct);
        Assertions.assertNotNull((Object)oldRoct);
        String badXML = "<configuration scan=\"true\" scanPeriod=\"5 millisecond\">\n  <root></configuration>";
        this.writeToFile(topLevelFile, badXML);
        this.addInfo("Waiting for changeDetectedLatch.await()", this);
        changeDetectedLatch.await();
        this.addInfo("Woke from changeDetectedLatch.await()", this);
        StatusPrinter.print((Context)this.loggerContext);
        try {
            this.statusChecker.assertContainsMatch(1, "Given previous errors, falling back to previously registered safe configuration.");
            this.statusChecker.assertContainsMatch(0, "Re-registering previous fallback configuration once more as a fallback configuration point");
            this.loggerContext.getStatusManager().clear();
            this.addInfo("after loggerContext.getStatusManager().clear() oldRoct=" + oldRoct, this);
            CountDownLatch secondDoneLatch = this.registerNewReconfigurationDoneListener_WithNewROCT(oldRoct);
            this.writeToFile(topLevelFile, "<configuration scan=\"true\" scanPeriod=\"5 millisecond\"><root level=\"ERROR\"/></configuration> ");
            secondDoneLatch.await();
            StatusPrinter.print((Context)this.loggerContext);
            this.statusChecker.assertIsErrorFree();
            this.statusChecker.containsMatch("Detected change in configuration files.");
        }
        finally {
            StatusPrinter.print((Context)this.loggerContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=3L, unit=TimeUnit.SECONDS)
    public void fallbackToSafeWithIncludedFile_FollowedByRecovery() throws IOException, JoranException, InterruptedException, ExecutionException {
        String topLevelFileAsStr = "target/test-output/reconfigureOnChangeConfig_top-" + this.diff + ".xml";
        String innerFileAsStr = "target/test-output/reconfigureOnChangeConfig_inner-" + this.diff + ".xml";
        File topLevelFile = new File(topLevelFileAsStr);
        this.writeToFile(topLevelFile, "<configuration xdebug=\"true\" scan=\"true\" scanPeriod=\"5 millisecond\"><include file=\"" + innerFileAsStr + "\"/></configuration> ");
        File innerFile = new File(innerFileAsStr);
        this.writeToFile(innerFile, "<included><root level=\"ERROR\"/></included> ");
        this.configure(topLevelFile);
        CountDownLatch doneLatch = this.registerNewReconfigurationDoneListener_WithNewROCT(null);
        ReconfigureOnChangeTask oldRoct = this.getRegisteredReconfigureTask();
        Assertions.assertNotNull((Object)oldRoct);
        this.writeToFile(innerFile, "<included>\n<root>\n</included>");
        doneLatch.await(2000L, TimeUnit.MILLISECONDS);
        this.statusChecker.assertContainsMatch(1, "Given previous errors, falling back to previously registered safe configuration.");
        this.statusChecker.assertContainsMatch(0, "Re-registering previous fallback configuration once more as a fallback configuration point");
        this.loggerContext.getStatusManager().clear();
        try {
            CountDownLatch secondDoneLatch = this.registerNewReconfigurationDoneListener_WithNewROCT(oldRoct);
            this.writeToFile(innerFile, "<included><root level=\"ERROR\"/></included> ");
            secondDoneLatch.await();
            this.statusChecker.assertIsErrorFree();
            this.statusChecker.containsMatch("Detected change in configuration files.");
        }
        finally {
            StatusPrinter.print((Context)this.loggerContext);
        }
    }

    private ReconfigureOnChangeTask getRegisteredReconfigureTask() {
        return (ReconfigureOnChangeTask)this.loggerContext.getObject("RECONFIGURE_ON_CHANGE_TASK");
    }

    private ReconfigureOnChangeTask waitForReconfigureOnChangeTaskToRun() throws InterruptedException {
        ReconfigureOnChangeTask roct = null;
        while (roct == null) {
            roct = this.getRegisteredReconfigureTask();
            Thread.yield();
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        roct.addListener((ReconfigureOnChangeTaskListener)new RunMethodInvokedListener(countDownLatch));
        countDownLatch.await();
        return roct;
    }

    private CountDownLatch registerNewReconfigurationDoneListener_WithNewROCT(ReconfigureOnChangeTask oldTask) throws InterruptedException {
        this.addInfo("waitForReconfigurationToBeDone oldTask=" + oldTask, this);
        ReconfigureOnChangeTask roct = oldTask;
        while (roct == oldTask) {
            roct = this.getRegisteredReconfigureTask();
            Thread.yield();
            Thread.sleep(10L);
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        if (roct == null) {
            this.addInfo("roct is null", oldTask);
        } else {
            roct.addListener((ReconfigureOnChangeTaskListener)new ReconfigurationDoneListener(countDownLatch));
        }
        return countDownLatch;
    }

    private RunnableWithCounterAndDone[] buildRunnableArray(File configFile, UpdateType updateType) {
        RunnableWithCounterAndDone[] rArray = new RunnableWithCounterAndDone[5];
        rArray[0] = new Updater(configFile, updateType);
        for (int i = 1; i < 5; ++i) {
            rArray[i] = new LoggingRunnable((org.slf4j.Logger)this.logger);
        }
        return rArray;
    }

    @Test
    public void checkReconfigureTaskScheduledWhenDefaultScanPeriodUsed() throws JoranException {
        File file = new File(SCAN_PERIOD_DEFAULT_FILE_AS_STR);
        this.configure(file);
        List scheduledFutures = this.loggerContext.getCopyOfScheduledFutures();
        StatusPrinter.print((Context)this.loggerContext);
        Assertions.assertFalse((boolean)scheduledFutures.isEmpty());
        this.statusChecker.containsMatch("No 'scanPeriod' specified. Defaulting to");
    }

    @Test
    @Timeout(value=4L, unit=TimeUnit.SECONDS)
    public void scan_LOGBACK_474() throws JoranException, IOException, InterruptedException {
        this.loggerContext.setName("scan_LOGBACK_474");
        File file = new File(SCAN_LOGBACK_474_FILE_AS_STR);
        this.configure(file);
        int expectedResets = 2;
        Harness harness = new Harness(expectedResets);
        RunnableWithCounterAndDone[] runnableArray = this.buildRunnableArray(file, UpdateType.TOUCH);
        harness.execute(runnableArray);
        this.loggerContext.getStatusManager().add((Status)new InfoStatus("end of execution ", (Object)this));
        StatusPrinter.print((Context)this.loggerContext);
        this.checkResetCount(expectedResets);
    }

    private void assertThatListContainsFile(List<File> fileList, File file) {
        Assertions.assertTrue((boolean)fileList.contains(file.getAbsoluteFile()));
    }

    private void checkResetCount(int expected) {
        StatusChecker checker = new StatusChecker((Context)this.loggerContext);
        checker.assertIsErrorFree();
        int effectiveResets = checker.matchCount("Will reset and reconfigure context ");
        Assertions.assertEquals((int)expected, (int)effectiveResets);
    }

    void addInfo(String msg, Object o) {
        this.loggerContext.getStatusManager().add((Status)new InfoStatus(msg, o));
    }

    void writeToFile(File file, String contents) throws IOException {
        FileWriter fw = new FileWriter(file);
        fw.write(contents);
        fw.close();
        file.setLastModified(System.currentTimeMillis() + (long)RandomUtil.getPositiveInt());
    }

    class RunMethodInvokedListener
    extends ReconfigureOnChangeTaskListener {
        CountDownLatch countDownLatch;

        RunMethodInvokedListener(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
        }

        public void enteredRunMethod() {
            this.countDownLatch.countDown();
        }
    }

    class ReconfigurationDoneListener
    extends ReconfigureOnChangeTaskListener {
        CountDownLatch countDownLatch;

        ReconfigurationDoneListener(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
        }

        public void doneReconfiguring() {
            System.out.println("ReconfigurationDoneListener now invoking countDownLatch.countDown()");
            this.countDownLatch.countDown();
        }
    }

    class Updater
    extends RunnableWithCounterAndDone {
        File configFile;
        UpdateType updateType;
        int sleepBetweenUpdates = 100;

        Updater(File configFile, UpdateType updateType) {
            this.configFile = configFile;
            this.updateType = updateType;
        }

        Updater(File configFile) {
            this(configFile, UpdateType.TOUCH);
        }

        public void run() {
            while (!this.isDone()) {
                try {
                    Thread.sleep(this.sleepBetweenUpdates);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.isDone()) {
                    ReconfigureOnChangeTaskTest.this.addInfo("Exiting Updater.run()", (Object)this);
                    return;
                }
                ++this.counter;
                ReconfigureOnChangeTaskTest.this.addInfo("Touching [" + this.configFile + "]", (Object)this);
                switch (this.updateType) {
                    case TOUCH: {
                        this.touchFile();
                        break;
                    }
                    case MALFORMED: {
                        try {
                            this.malformedUpdate();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            Assertions.fail((String)"malformedUpdate failed");
                        }
                        break;
                    }
                    case MALFORMED_INNER: {
                        try {
                            this.malformedInnerUpdate();
                            break;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            Assertions.fail((String)"malformedInnerUpdate failed");
                        }
                    }
                }
            }
            ReconfigureOnChangeTaskTest.this.addInfo("Exiting Updater.run()", (Object)this);
        }

        private void malformedUpdate() throws IOException {
            ReconfigureOnChangeTaskTest.this.writeToFile(this.configFile, "<configuration scan=\"true\" scanPeriod=\"50 millisecond\">\n  <root level=\"ERROR\">\n</configuration>");
        }

        private void malformedInnerUpdate() throws IOException {
            ReconfigureOnChangeTaskTest.this.writeToFile(this.configFile, "<included>\n  <root>\n</included>");
        }

        void touchFile() {
            this.configFile.setLastModified(System.currentTimeMillis());
        }
    }

    static enum UpdateType {
        TOUCH,
        MALFORMED,
        MALFORMED_INNER;

    }

    class Harness
    extends AbstractMultiThreadedHarness {
        int changeCountLimit;

        Harness(int changeCount) {
            this.changeCountLimit = changeCount;
        }

        public void waitUntilEndCondition() throws InterruptedException {
            ReconfigureOnChangeTaskTest.this.addInfo("Entering " + ((Object)((Object)this)).getClass() + ".waitUntilEndCondition()", (Object)this);
            int changeCount = 0;
            ReconfigureOnChangeTask lastRoct = null;
            CountDownLatch countDownLatch = null;
            while (changeCount < this.changeCountLimit) {
                ReconfigureOnChangeTask roct = (ReconfigureOnChangeTask)ReconfigureOnChangeTaskTest.this.loggerContext.getObject("RECONFIGURE_ON_CHANGE_TASK");
                if (lastRoct != roct && roct != null) {
                    lastRoct = roct;
                    countDownLatch = new CountDownLatch(1);
                    roct.addListener((ReconfigureOnChangeTaskListener)new ChangeDetectedListener(countDownLatch));
                } else if (countDownLatch != null) {
                    countDownLatch.await();
                    countDownLatch = null;
                    ++changeCount;
                }
                Thread.yield();
            }
            ReconfigureOnChangeTaskTest.this.addInfo("*****Exiting " + ((Object)((Object)this)).getClass() + ".waitUntilEndCondition()", (Object)this);
        }
    }

    class ChangeDetectedListener
    extends ReconfigureOnChangeTaskListener {
        CountDownLatch countDownLatch;

        ChangeDetectedListener(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
        }

        public void changeDetected() {
            this.countDownLatch.countDown();
        }
    }
}

