/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran.sanity;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.sanity.IfNestedWithinSecondPhaseElementSC;
import ch.qos.logback.classic.model.LoggerModel;
import ch.qos.logback.classic.model.RootLoggerModel;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.AppenderModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.TopModel;
import ch.qos.logback.core.model.conditional.IfModel;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import ch.qos.logback.core.util.StatusPrinter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IfNestedWithinSecondPhaseElementSCTest {
    LoggerContext context = new LoggerContext();
    IfNestedWithinSecondPhaseElementSC inwspeChecker = new IfNestedWithinSecondPhaseElementSC();
    StatusChecker statusChecker = new StatusChecker((Context)this.context);

    @BeforeEach
    public void setUp() throws Exception {
        this.inwspeChecker.setContext((Context)this.context);
    }

    @Test
    public void smoke() {
        TopModel topModel = new TopModel();
        this.inwspeChecker.check((Model)topModel);
        this.statusChecker.assertIsWarningOrErrorFree();
    }

    @Test
    public void singleAppender() {
        TopModel topModel = new TopModel();
        AppenderModel appenderModel0 = new AppenderModel();
        appenderModel0.setLineNumber(1);
        topModel.addSubModel((Model)appenderModel0);
        this.inwspeChecker.check((Model)topModel);
        this.statusChecker.assertIsWarningOrErrorFree();
    }

    @Test
    public void singleLoggerWithNestedIf() {
        TopModel topModel = new TopModel();
        Model rootLoggerModel = this.setupModel((Model)new RootLoggerModel(), "root", 1);
        topModel.addSubModel(rootLoggerModel);
        Model ifModel0 = this.setupModel((Model)new IfModel(), "if", 2);
        rootLoggerModel.addSubModel(ifModel0);
        Model loggerModel = this.setupModel((Model)new LoggerModel(), "logger", 3);
        topModel.addSubModel(loggerModel);
        Model ifModel1 = this.setupModel((Model)new IfModel(), "if", 4);
        loggerModel.addSubModel(ifModel1);
        Model appenderModel = this.setupModel((Model)new LoggerModel(), "appender", 5);
        topModel.addSubModel(appenderModel);
        Model ifModel2 = this.setupModel((Model)new IfModel(), "if", 6);
        appenderModel.addSubModel(ifModel2);
        this.inwspeChecker.check((Model)topModel);
        StatusPrinter.print((Context)this.context);
        String regex0 = "Element <root> at line 1 contains a nested <if> element at line 2";
        this.statusChecker.assertContainsMatch(1, regex0);
        String regex1 = "Element <logger> at line 3 contains a nested <if> element at line 4";
        this.statusChecker.assertContainsMatch(1, regex1);
        String regex2 = "Element <appender> at line 5 contains a nested <if> element at line 6";
        this.statusChecker.assertContainsMatch(1, regex2);
    }

    private Model setupModel(Model m, String tag, int line) {
        m.setLineNumber(line);
        m.setTag(tag);
        return m;
    }
}

