/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.status.Status;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LoggingEventBuilder;
import org.slf4j.spi.NOPLoggingEventBuilder;

public class LoggerTest {
    LoggerContext lc = new LoggerContext();
    Logger root = this.lc.getLogger("ROOT");
    Logger loggerTest = this.lc.getLogger(LoggerTest.class);
    ListAppender<ILoggingEvent> listAppender = new ListAppender();

    @Test
    public void smoke() {
        ListAppender listAppender = new ListAppender();
        listAppender.start();
        this.root.addAppender((Appender)listAppender);
        Logger logger = this.lc.getLogger(LoggerTest.class);
        Assertions.assertEquals((int)0, (int)listAppender.list.size());
        logger.debug("hello");
        Assertions.assertEquals((int)1, (int)listAppender.list.size());
    }

    @Test
    public void testNoStart() {
        this.listAppender.setContext((Context)this.lc);
        this.root.addAppender(this.listAppender);
        Logger logger = this.lc.getLogger(LoggerTest.class);
        logger.debug("hello");
        List statusList = this.lc.getStatusManager().getCopyOfStatusList();
        Status s0 = (Status)statusList.get(0);
        Assertions.assertEquals((int)1, (int)s0.getLevel());
        Assertions.assertTrue((boolean)s0.getMessage().startsWith("Attempted to append to non started"));
    }

    @Test
    public void testAdditive() {
        this.listAppender.start();
        this.root.addAppender(this.listAppender);
        this.loggerTest.addAppender(this.listAppender);
        this.loggerTest.setAdditive(false);
        this.loggerTest.debug("hello");
        Assertions.assertEquals((int)1, (int)this.listAppender.list.size());
    }

    @Test
    public void testRootLogger() {
        Logger logger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        LoggerContext lc = logger.getLoggerContext();
        Assertions.assertNotNull((Object)logger, (String)"Returned logger is null");
        Assertions.assertEquals((Object)logger.getName(), (Object)"ROOT", (String)"Return logger isn't named root");
        Assertions.assertTrue((logger == lc.root ? 1 : 0) != 0, (String)"logger instances should be indentical");
    }

    @Test
    public void testBasicFiltering() throws Exception {
        this.listAppender.start();
        this.root.addAppender(this.listAppender);
        this.root.setLevel(Level.INFO);
        this.loggerTest.debug("x");
        Assertions.assertEquals((int)0, (int)this.listAppender.list.size());
        this.loggerTest.info("x");
        this.loggerTest.warn("x");
        this.loggerTest.error("x");
        Assertions.assertEquals((int)3, (int)this.listAppender.list.size());
    }

    void checkLevelThreshold(Logger logger, Level threshold) {
        if (40000 >= threshold.levelInt) {
            Assertions.assertTrue((boolean)logger.isErrorEnabled());
            Assertions.assertTrue((boolean)logger.isEnabledFor(Level.ERROR));
        } else {
            Assertions.assertFalse((boolean)logger.isErrorEnabled());
            Assertions.assertFalse((boolean)logger.isEnabledFor(Level.ERROR));
        }
        if (30000 >= threshold.levelInt) {
            Assertions.assertTrue((boolean)logger.isWarnEnabled());
            Assertions.assertTrue((boolean)logger.isEnabledFor(Level.WARN));
        } else {
            Assertions.assertFalse((boolean)logger.isWarnEnabled());
            Assertions.assertFalse((boolean)logger.isEnabledFor(Level.WARN));
        }
        if (20000 >= threshold.levelInt) {
            Assertions.assertTrue((boolean)logger.isInfoEnabled());
            Assertions.assertTrue((boolean)logger.isEnabledFor(Level.INFO));
        } else {
            Assertions.assertFalse((boolean)logger.isInfoEnabled());
            Assertions.assertFalse((boolean)logger.isEnabledFor(Level.INFO));
        }
        if (10000 >= threshold.levelInt) {
            Assertions.assertTrue((boolean)logger.isDebugEnabled());
            Assertions.assertTrue((boolean)logger.isEnabledFor(Level.DEBUG));
        } else {
            Assertions.assertFalse((boolean)logger.isDebugEnabled());
            Assertions.assertFalse((boolean)logger.isEnabledFor(Level.DEBUG));
        }
        if (5000 >= threshold.levelInt) {
            Assertions.assertTrue((boolean)logger.isTraceEnabled());
            Assertions.assertTrue((boolean)logger.isEnabledFor(Level.TRACE));
        } else {
            Assertions.assertFalse((boolean)logger.isTraceEnabled());
            Assertions.assertFalse((boolean)logger.isEnabledFor(Level.TRACE));
        }
    }

    @Test
    public void innerClass_I() {
        this.root.setLevel(Level.DEBUG);
        Logger a = this.lc.getLogger("a");
        a.setLevel(Level.INFO);
        Logger a_b = this.lc.getLogger("a$b");
        Assertions.assertEquals((Object)Level.INFO, (Object)a_b.getEffectiveLevel());
    }

    @Test
    public void innerClass_II() {
        this.root.setLevel(Level.DEBUG);
        Logger a = this.lc.getLogger(this.getClass());
        a.setLevel(Level.INFO);
        Logger a_b = this.lc.getLogger(new Inner().getClass());
        Assertions.assertEquals((Object)Level.INFO, (Object)a_b.getEffectiveLevel());
    }

    @Test
    public void testEnabled_All() throws Exception {
        this.root.setLevel(Level.ALL);
        this.checkLevelThreshold(this.loggerTest, Level.ALL);
    }

    @Test
    public void fluentAPIAtDisabledDebugLevelShouldReturnNOPLoggingEventBuilder() throws Exception {
        this.root.setLevel(Level.INFO);
        LoggingEventBuilder leb = this.loggerTest.atLevel(org.slf4j.event.Level.DEBUG);
        Assertions.assertEquals(NOPLoggingEventBuilder.class, (Object)leb.getClass());
    }

    @Test
    public void testEnabled_Debug() throws Exception {
        this.root.setLevel(Level.DEBUG);
        this.checkLevelThreshold(this.loggerTest, Level.DEBUG);
    }

    @Test
    public void testEnabled_Info() throws Exception {
        this.root.setLevel(Level.INFO);
        this.checkLevelThreshold(this.loggerTest, Level.INFO);
    }

    @Test
    public void testEnabledX_Warn() throws Exception {
        this.root.setLevel(Level.WARN);
        this.checkLevelThreshold(this.loggerTest, Level.WARN);
    }

    public void testEnabledX_Errror() throws Exception {
        this.root.setLevel(Level.ERROR);
        this.checkLevelThreshold(this.loggerTest, Level.ERROR);
    }

    @Test
    public void testEnabledX_Off() throws Exception {
        this.root.setLevel(Level.OFF);
        this.checkLevelThreshold(this.loggerTest, Level.OFF);
    }

    @Test
    public void setRootLevelToNull() {
        try {
            this.root.setLevel(null);
            Assertions.fail((String)"The level of the root logger should not be settable to null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setLevelToNull_A() {
        this.loggerTest.setLevel(null);
        Assertions.assertEquals((Object)this.root.getEffectiveLevel(), (Object)this.loggerTest.getEffectiveLevel());
    }

    @Test
    public void setLevelToNull_B() {
        this.loggerTest.setLevel(Level.DEBUG);
        this.loggerTest.setLevel(null);
        Assertions.assertEquals((Object)this.root.getEffectiveLevel(), (Object)this.loggerTest.getEffectiveLevel());
    }

    @Test
    public void setLevelToNull_LBCLASSIC_91() {
        this.loggerTest.setLevel(Level.DEBUG);
        Logger child = this.lc.getLogger(this.loggerTest.getName() + ".child");
        this.loggerTest.setLevel(null);
        Assertions.assertEquals((Object)this.root.getEffectiveLevel(), (Object)this.loggerTest.getEffectiveLevel());
        Assertions.assertEquals((Object)this.root.getEffectiveLevel(), (Object)child.getEffectiveLevel());
    }

    class Inner {
        Inner() {
        }
    }
}

