/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.html;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.html.DefaultThrowableRenderer;
import ch.qos.logback.classic.html.HTMLLayout;
import ch.qos.logback.classic.html.XHTMLEntityResolver;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.DummyThrowableProxy;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.html.IThrowableRenderer;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.testUtil.StringListAppender;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.xml.sax.EntityResolver;

public class HTMLLayoutTest {
    LoggerContext lc;
    Logger root;
    HTMLLayout layout;

    @BeforeEach
    public void setUp() throws Exception {
        this.lc = new LoggerContext();
        this.lc.setName("default");
        this.layout = new HTMLLayout();
        this.layout.setThrowableRenderer((IThrowableRenderer)new DefaultThrowableRenderer());
        this.layout.setContext((Context)this.lc);
        this.layout.setPattern("%level%thread%msg");
        this.layout.start();
        this.root = this.lc.getLogger("ROOT");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.lc = null;
        this.layout = null;
    }

    @Test
    public void testHeader() throws Exception {
        String header = this.layout.getFileHeader();
        Document doc = this.parseOutput(header + "</body></html>");
        Element rootElement = doc.getRootElement();
        Assertions.assertNotNull((Object)rootElement.element("body"));
    }

    @Test
    public void testPresentationHeader() throws Exception {
        String header = this.layout.getFileHeader();
        String presentationHeader = this.layout.getPresentationHeader();
        header = header + presentationHeader;
        Document doc = this.parseOutput(header + "</table></body></html>");
        Element rootElement = doc.getRootElement();
        Element bodyElement = rootElement.element("body");
        Element tableElement = bodyElement.element("table");
        Element trElement = tableElement.element("tr");
        List elementList = trElement.elements();
        Assertions.assertEquals((Object)"Level", (Object)((Element)elementList.get(0)).getText());
        Assertions.assertEquals((Object)"Thread", (Object)((Element)elementList.get(1)).getText());
        Assertions.assertEquals((Object)"Message", (Object)((Element)elementList.get(2)).getText());
    }

    @Test
    public void testAppendThrowable() throws Exception {
        StringBuilder buf = new StringBuilder();
        DummyThrowableProxy tp = new DummyThrowableProxy();
        tp.setClassName("test1");
        tp.setMessage("msg1");
        StackTraceElement ste1 = new StackTraceElement("c1", "m1", "f1", 1);
        StackTraceElement ste2 = new StackTraceElement("c2", "m2", "f2", 2);
        StackTraceElementProxy[] stepArray = new StackTraceElementProxy[]{new StackTraceElementProxy(ste1), new StackTraceElementProxy(ste2)};
        tp.setStackTraceElementProxyArray(stepArray);
        DefaultThrowableRenderer renderer = (DefaultThrowableRenderer)this.layout.getThrowableRenderer();
        renderer.render(buf, (IThrowableProxy)tp);
        System.out.println(buf.toString());
        String[] result = buf.toString().split(CoreConstants.LINE_SEPARATOR);
        System.out.println(result[0]);
        Assertions.assertEquals((Object)"test1: msg1", (Object)result[0]);
        Assertions.assertEquals((Object)"<br />&nbsp;&nbsp;&nbsp;&nbsp;at c1.m1(f1:1)", (Object)result[1]);
    }

    @Test
    public void testDoLayout() throws Exception {
        LoggingEvent le = this.createLoggingEvent();
        String result = this.layout.getFileHeader();
        result = result + this.layout.getPresentationHeader();
        result = result + this.layout.doLayout((ILoggingEvent)le);
        result = result + this.layout.getPresentationFooter();
        result = result + this.layout.getFileFooter();
        Document doc = this.parseOutput(result);
        Element rootElement = doc.getRootElement();
        rootElement.toString();
        Assertions.assertEquals((int)2, (int)rootElement.elements().size());
        Element bodyElement = (Element)rootElement.elements().get(1);
        Element tableElement = (Element)bodyElement.elements().get(3);
        Assertions.assertEquals((Object)"table", (Object)tableElement.getName());
        Element trElement = (Element)tableElement.elements().get(1);
        Element tdElement = (Element)trElement.elements().get(0);
        Assertions.assertEquals((Object)"DEBUG", (Object)tdElement.getText());
        tdElement = (Element)trElement.elements().get(1);
        String regex = "([mM]ain|pool-\\d-)([Tt]hread)?(-\\d{1,3})?";
        System.out.println(tdElement.getText());
        Assertions.assertTrue((boolean)tdElement.getText().matches(regex));
        tdElement = (Element)trElement.elements().get(2);
        Assertions.assertEquals((Object)"test message", (Object)tdElement.getText());
    }

    @Test
    public void layoutWithException() throws Exception {
        this.layout.setPattern("%level %thread %msg %ex");
        LoggingEvent le = this.createLoggingEvent();
        le.setThrowableProxy(new ThrowableProxy((Throwable)new Exception("test Exception")));
        String result = this.layout.doLayout((ILoggingEvent)le);
        String stringToParse = this.layout.getFileHeader();
        stringToParse = stringToParse + this.layout.getPresentationHeader();
        stringToParse = stringToParse + result;
        stringToParse = stringToParse + "</table></body></html>";
        Document doc = this.parseOutput(stringToParse);
        Element rootElement = doc.getRootElement();
        Element bodyElement = rootElement.element("body");
        Element tableElement = bodyElement.element("table");
        List trElementList = tableElement.elements();
        Element exceptionRowElement = (Element)trElementList.get(2);
        Element exceptionElement = exceptionRowElement.element("td");
        Assertions.assertEquals((int)3, (int)tableElement.elements().size());
        Assertions.assertTrue((boolean)exceptionElement.getText().contains("java.lang.Exception: test Exception"));
    }

    @Test
    @Disabled
    public void rawLimit() throws Exception {
        StringBuilder sb = new StringBuilder();
        String header = this.layout.getFileHeader();
        Assertions.assertTrue((boolean)header.startsWith("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">"));
        sb.append(header);
        sb.append(this.layout.getPresentationHeader());
        for (int i = 0; i < 30000; ++i) {
            sb.append(this.layout.doLayout((ILoggingEvent)new LoggingEvent(this.getClass().getName(), this.root, Level.DEBUG, "test message" + i, null, null)));
        }
        sb.append(this.layout.getPresentationFooter());
        sb.append(this.layout.getFileFooter());
        this.parseOutput(sb.toString());
    }

    private LoggingEvent createLoggingEvent() {
        return new LoggingEvent(this.getClass().getName(), this.root, Level.DEBUG, "test message", null, null);
    }

    Document parseOutput(String output) throws Exception {
        XHTMLEntityResolver resolver = new XHTMLEntityResolver();
        SAXReader reader = new SAXReader();
        reader.setValidation(true);
        reader.setEntityResolver((EntityResolver)resolver);
        return reader.read((InputStream)new ByteArrayInputStream(output.getBytes()));
    }

    void configure(String file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.lc);
        jc.doConfigure(file);
    }

    @Test
    public void testConversionRuleSupportInHtmlLayout() throws JoranException {
        this.configure("src/test/input/joran/conversionRule/htmlLayout0.xml");
        this.root.getAppender("LIST");
        String msg = "Simon says";
        this.root.debug(msg);
        StringListAppender sla = (StringListAppender)this.root.getAppender("LIST");
        Assertions.assertNotNull((Object)sla);
        StatusPrinter.print((Context)this.lc);
        Assertions.assertEquals((int)1, (int)sla.strList.size());
        Assertions.assertFalse((boolean)((String)sla.strList.get(0)).contains("PARSER_ERROR"));
    }
}

