/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.SimpleSocketServer;
import ch.qos.logback.classic.net.SocketAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Disabled
public class SocketAppenderMessageLossTest {
    int runLen = 100;
    Duration reconnectionDelay = new Duration(1000L);
    static final int TIMEOUT = 3000;

    @Test
    public void synchronousSocketAppender() throws Exception {
        SocketAppender socketAppender = new SocketAppender();
        socketAppender.setReconnectionDelay(this.reconnectionDelay);
        socketAppender.setIncludeCallerData(true);
        this.runTest(socketAppender);
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void smallQueueSocketAppender() throws Exception {
        SocketAppender socketAppender = new SocketAppender();
        socketAppender.setReconnectionDelay(this.reconnectionDelay);
        socketAppender.setQueueSize(this.runLen / 10);
        this.runTest(socketAppender);
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void largeQueueSocketAppender() throws Exception {
        SocketAppender socketAppender = new SocketAppender();
        socketAppender.setReconnectionDelay(this.reconnectionDelay);
        socketAppender.setQueueSize(this.runLen * 5);
        this.runTest(socketAppender);
    }

    public void runTest(SocketAppender socketAppender) throws Exception {
        int port = RandomUtil.getRandomServerPort();
        LoggerContext serverLoggerContext = new LoggerContext();
        serverLoggerContext.setName("serverLoggerContext");
        CountDownLatch allMessagesReceivedLatch = new CountDownLatch(this.runLen);
        ListAppenderWithLatch listAppender = new ListAppenderWithLatch(allMessagesReceivedLatch);
        listAppender.setContext((Context)serverLoggerContext);
        listAppender.start();
        Logger serverRootLogger = serverLoggerContext.getLogger("ROOT");
        serverRootLogger.setAdditive(false);
        serverRootLogger.addAppender((Appender)listAppender);
        LoggerContext loggerContext = new LoggerContext();
        loggerContext.setName("clientLoggerContext");
        socketAppender.setContext((Context)loggerContext);
        CountDownLatch latch = new CountDownLatch(1);
        SimpleSocketServer simpleSocketServer = new SimpleSocketServer(serverLoggerContext, port);
        simpleSocketServer.start();
        simpleSocketServer.setLatch(latch);
        latch.await();
        socketAppender.setPort(port);
        socketAppender.setRemoteHost("localhost");
        socketAppender.setReconnectionDelay(this.reconnectionDelay);
        socketAppender.start();
        Assertions.assertTrue((boolean)socketAppender.isStarted());
        Logger logger = loggerContext.getLogger(this.getClass());
        logger.setAdditive(false);
        logger.addAppender((Appender)socketAppender);
        for (int i = 0; i < this.runLen; ++i) {
            logger.info("hello");
        }
        allMessagesReceivedLatch.await();
        loggerContext.stop();
        simpleSocketServer.close();
    }

    public static class ListAppenderWithLatch
    extends AppenderBase<ILoggingEvent> {
        public List<ILoggingEvent> list = new ArrayList<ILoggingEvent>();
        CountDownLatch latch;

        ListAppenderWithLatch(CountDownLatch latch) {
            this.latch = latch;
        }

        protected void append(ILoggingEvent e) {
            this.list.add(e);
            this.latch.countDown();
        }
    }
}

