/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.turbo.lru;

import ch.qos.logback.classic.turbo.lru.Event;
import ch.qos.logback.classic.turbo.lru.LRUCache;
import ch.qos.logback.classic.turbo.lru.Simulator;
import ch.qos.logback.classic.turbo.lru.T_LRUCache;
import java.util.LinkedList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled
public class LRUCacheTest {
    @Test
    public void smoke() {
        LRUCache<String, String> cache = new LRUCache<String, String>(2);
        cache.put("a", "a");
        cache.put("b", "b");
        cache.put("c", "c");
        LinkedList<String> witness = new LinkedList<String>();
        witness.add("b");
        witness.add("c");
        Assertions.assertEquals(witness, cache.keyList());
    }

    @Test
    public void typicalScenarioTest() {
        int simulationLen = 10000;
        int cacheSize = 100;
        int worldSize = 1000;
        this.doScenario(simulationLen, cacheSize, worldSize);
    }

    @Test
    public void scenarioCoverageTest() {
        int simulationLen = 10000;
        int[] cacheSizes = new int[]{1, 10, 100};
        int[] worldSizes = new int[]{1, 10, 100};
        for (int i = 0; i < cacheSizes.length; ++i) {
            for (int j = 0; j < worldSizes.length; ++j) {
                this.doScenario(simulationLen, cacheSizes[i], worldSizes[j]);
            }
        }
    }

    void doScenario(int simulationLen, int cacheSize, int worldSize) {
        int get2PutRatio = 10;
        Simulator simulator = new Simulator(worldSize, get2PutRatio, false);
        List<Event<String>> scenario = simulator.generateScenario(simulationLen);
        LRUCache<String, String> lruCache = new LRUCache<String, String>(cacheSize);
        T_LRUCache<String> tlruCache = new T_LRUCache<String>(cacheSize);
        long start = System.nanoTime();
        simulator.simulate(scenario, lruCache, tlruCache);
        long end = System.nanoTime();
        System.out.println("cacheSize=" + cacheSize + ", worldSize=" + worldSize + ", elapsed time=" + (end - start) / 1000000L + " in millis");
    }

    @Test
    @Disabled
    public void multiThreadedScenario() throws InterruptedException {
        int i;
        int cacheSize = 100;
        int worldSize = cacheSize * 2;
        LRUCache<String, String> lruCache = new LRUCache<String, String>(cacheSize);
        T_LRUCache<String> tlruCache = new T_LRUCache<String>(cacheSize);
        SimulatorRunnable[] simulatorArray = new SimulatorRunnable[5];
        for (i = 0; i < simulatorArray.length; ++i) {
            simulatorArray[i] = new SimulatorRunnable(lruCache, tlruCache, worldSize);
        }
        for (i = 0; i < simulatorArray.length; ++i) {
            simulatorArray[i].start();
        }
        for (i = 0; i < simulatorArray.length; ++i) {
            simulatorArray[i].join();
        }
        Assertions.assertEquals(tlruCache.keyList(), lruCache.keyList());
    }

    private class SimulatorRunnable
    extends Thread {
        LRUCache<String, String> lruCache;
        T_LRUCache<String> tlruCache;
        int worldSize;

        SimulatorRunnable(LRUCache<String, String> lruCache, T_LRUCache<String> tlruCache, int worldSize) {
            this.lruCache = lruCache;
            this.tlruCache = tlruCache;
            this.worldSize = worldSize;
        }

        @Override
        public void run() {
            int get2PutRatio = 10;
            int simulationLen = 50000;
            Simulator simulator = new Simulator(this.worldSize, get2PutRatio, true);
            List<Event<String>> scenario = simulator.generateScenario(simulationLen);
            simulator.simulate(scenario, this.lruCache, this.tlruCache);
            System.out.println("done");
        }
    }
}

