/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.turbo.lru;

import ch.qos.logback.classic.turbo.lru.Event;
import ch.qos.logback.classic.turbo.lru.LRUCache;
import ch.qos.logback.classic.turbo.lru.T_LRUCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;

public class Simulator {
    Random random;
    int worldSize;
    int get2PutRatio;
    boolean multiThreaded;

    public Simulator(int worldSize, int get2PutRatio, boolean multiThreaded) {
        this.worldSize = worldSize;
        this.get2PutRatio = get2PutRatio;
        long seed = System.nanoTime();
        this.random = new Random(seed);
        this.multiThreaded = multiThreaded;
    }

    public List<Event<String>> generateScenario(int len) {
        ArrayList<Event<String>> scenario = new ArrayList<Event<String>>();
        for (int i = 0; i < len; ++i) {
            int r = this.random.nextInt(this.get2PutRatio);
            boolean put = false;
            if (r == 0) {
                put = true;
            }
            r = this.random.nextInt(this.worldSize);
            Event<String> e = new Event<String>(put, String.valueOf(r));
            scenario.add(e);
        }
        return scenario;
    }

    public void simulate(List<Event<String>> scenario, LRUCache<String, String> lruCache, T_LRUCache<String> tlruCache) {
        for (Event<String> e : scenario) {
            if (e.put) {
                lruCache.put((String)e.k, (String)e.k);
                tlruCache.put((String)e.k);
                continue;
            }
            String r0 = (String)lruCache.get(e.k);
            String r1 = tlruCache.get((String)e.k);
            if (this.multiThreaded) continue;
            if (r0 != null) {
                Assertions.assertEquals((Object)r0, e.k);
            }
            Assertions.assertEquals((Object)r0, (Object)r1);
        }
    }
}

