/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net.server;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.mock.MockAppender;
import ch.qos.logback.classic.net.server.InstrumentedServerSocketReceiver;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.LoggingEventVO;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.net.server.test.ServerSocketUtil;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ServerSocketReceiverFunctionalTest {
    private static final int EVENT_COUNT = 10;
    private static final int SHUTDOWN_DELAY = 10000;
    private MockAppender appender;
    private Logger logger;
    private ServerSocket serverSocket;
    private InstrumentedServerSocketReceiver receiver;
    private LoggerContext lc;

    @BeforeEach
    public void setUp() throws Exception {
        this.lc = new LoggerContext();
        this.appender = new MockAppender();
        this.appender.start();
        this.logger = this.lc.getLogger(this.getClass());
        this.logger.addAppender((Appender)this.appender);
        this.serverSocket = ServerSocketUtil.createServerSocket();
        this.receiver = new InstrumentedServerSocketReceiver(this.serverSocket);
        this.receiver.setContext((Context)this.lc);
        this.receiver.start();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.receiver.stop();
        ExecutorService executor = this.lc.getExecutorService();
        executor.shutdownNow();
        executor.awaitTermination(10000L, TimeUnit.MILLISECONDS);
        Assertions.assertTrue((boolean)executor.isTerminated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogEventFromClient() throws Exception {
        LoggingEvent event = new LoggingEvent(this.logger.getName(), this.logger, Level.DEBUG, "test message", null, new Object[0]);
        try (Socket socket = new Socket(InetAddress.getLocalHost(), this.serverSocket.getLocalPort());){
            LoggingEventVO eventVO = LoggingEventVO.build((ILoggingEvent)event);
            ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
            for (int i = 0; i < 10; ++i) {
                oos.writeObject(eventVO);
            }
            oos.writeObject(eventVO);
            oos.flush();
        }
        ILoggingEvent rcvdEvent = this.appender.awaitAppend(10000L);
        Assertions.assertNotNull((Object)rcvdEvent);
        Assertions.assertEquals((Object)event.getLoggerName(), (Object)rcvdEvent.getLoggerName());
        Assertions.assertEquals((Object)event.getLevel(), (Object)rcvdEvent.getLevel());
        Assertions.assertEquals((Object)event.getMessage(), (Object)rcvdEvent.getMessage());
    }
}

