/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.LoggerConverter;
import ch.qos.logback.classic.pattern.LoggerNameOnlyLoggingEvent;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.testUtil.Gaussian;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.StatusListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Disabled
public class LoggerNameConverterPerfTest {
    static final String NAMES_FILE = "src/test/input/fqcn.txt";
    static List<String> NAMES_LIST;
    static int SIZE;
    static double MEAN;
    static double DEVIATION;
    static Gaussian G;
    LoggerContext loggerContext = new LoggerContext();
    LoggerConverter loggerConverter = new LoggerConverter();
    LoggerNameOnlyLoggingEvent event = new LoggerNameOnlyLoggingEvent();
    Logger logger = LoggerFactory.getLogger(this.getClass());

    @BeforeAll
    public static void loadClassNames() throws IOException {
        NAMES_LIST = Files.lines(Paths.get(NAMES_FILE, new String[0])).collect(Collectors.toList());
        SIZE = NAMES_LIST.size();
        MEAN = SIZE / 2;
        DEVIATION = MEAN / 8.0;
        G = new Gaussian(MEAN, DEVIATION);
        System.out.println("names list size=" + SIZE);
    }

    @BeforeEach
    public void setUp() {
        OnConsoleStatusListener ocsl = new OnConsoleStatusListener();
        ocsl.setContext((Context)this.loggerContext);
        ocsl.start();
        this.loggerContext.getStatusManager().add((StatusListener)ocsl);
        this.loggerConverter.setOptionList(Arrays.asList("30"));
        this.loggerConverter.setContext((Context)this.loggerContext);
        this.loggerConverter.start();
    }

    @AfterEach
    public void tearDown() {
    }

    @Test
    public void measureAbbreviationPerf() {
        int i;
        for (i = 0; i < 10000; ++i) {
            this.performAbbreviation();
        }
        for (i = 0; i < 10000; ++i) {
            this.performAbbreviation();
        }
        int runLength = 1000000;
        System.out.println("Start measurements");
        long start = System.nanoTime();
        for (int i2 = 0; i2 < 1000000; ++i2) {
            this.performAbbreviation();
        }
        long end = System.nanoTime();
        long diff = end - start;
        double average = (double)diff * 1.0 / 1000000.0;
        this.logger.atInfo().addArgument((Object)average).log("Average = {} nanos");
        int cacheMisses = this.loggerConverter.getCacheMisses();
        this.logger.atInfo().addArgument((Object)cacheMisses).log("cacheMisses = {} ");
        this.logger.atInfo().addArgument((Object)1000000).log("total calls= = {} ");
        double cacheMissRate = this.loggerConverter.getCacheMissRate() * 100.0;
        this.logger.atInfo().addArgument((Object)cacheMissRate).log("cacheMiss rate %= {} ");
    }

    public void performAbbreviation() {
        String fqn = this.getFQN();
        this.event.setLoggerName(fqn);
        this.loggerConverter.convert((ILoggingEvent)this.event);
    }

    private String getFQN() {
        int index;
        while ((index = (int)G.getGaussian()) < 0 || index >= SIZE) {
        }
        return NAMES_LIST.get(index);
    }
}

