/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.selector;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.selector.ContextDetachingSCLTest;
import ch.qos.logback.classic.selector.ContextJNDISelector;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.classic.util.ContextSelectorStaticBinder;
import ch.qos.logback.core.testUtil.MockInitialContext;
import ch.qos.logback.core.testUtil.MockInitialContextFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.LoggerFactory;
import org.slf4j.LoggerFactoryFriend;

@Disabled
public class ContextJNDISelectorTest {
    static String INITIAL_CONTEXT_KEY = "java.naming.factory.initial";

    @BeforeEach
    public void setUp() throws Exception {
        System.setProperty("logback.ContextSelector", "JNDI");
        LoggerFactoryFriend.reset();
        MockInitialContextFactory.initialize();
        MockInitialContext mic = MockInitialContextFactory.getContext();
        mic.map.put("java:comp/env/logback/context-name", "toto");
        System.setProperty(INITIAL_CONTEXT_KEY, MockInitialContextFactory.class.getName());
        LoggerFactory.getLogger(ContextDetachingSCLTest.class);
    }

    @AfterEach
    public void tearDown() throws Exception {
        System.clearProperty(INITIAL_CONTEXT_KEY);
    }

    @Test
    public void testGetExistingContext() {
        ContextSelector selector = ContextSelectorStaticBinder.getSingleton().getContextSelector();
        LoggerContext context = selector.getLoggerContext();
        Assertions.assertEquals((Object)"toto", (Object)context.getName());
    }

    @Test
    public void testCreateContext() {
        MockInitialContext mic = MockInitialContextFactory.getContext();
        mic.map.put("java:comp/env/logback/context-name", "tata");
        LoggerFactory.getLogger(ContextDetachingSCLTest.class);
        ContextJNDISelector selector = (ContextJNDISelector)ContextSelectorStaticBinder.getSingleton().getContextSelector();
        LoggerContext context = selector.getLoggerContext();
        Assertions.assertEquals((Object)"tata", (Object)context.getName());
        System.out.println(selector.getContextNames());
        Assertions.assertEquals((int)2, (int)selector.getCount());
    }

    @Test
    public void defaultContext() {
        MockInitialContext mic = MockInitialContextFactory.getContext();
        mic.map.put("java:comp/env/logback/context-name", null);
        ContextJNDISelector selector = (ContextJNDISelector)ContextSelectorStaticBinder.getSingleton().getContextSelector();
        LoggerContext context = selector.getLoggerContext();
        Assertions.assertEquals((Object)"default", (Object)context.getName());
    }
}

