/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.testObjectBuilders.LoggingEventBuilderInContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.util.LogbackMDCAdapter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.testUtil.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.MDC;

public class AsyncAppenderTest {
    String thisClassName = this.getClass().getName();
    LoggerContext loggerContext = new LoggerContext();
    LogbackMDCAdapter logbackMDCAdapter = new LogbackMDCAdapter();
    AsyncAppender asyncAppender = new AsyncAppender();
    ListAppender<ILoggingEvent> listAppender = new ListAppender();
    OnConsoleStatusListener onConsoleStatusListener = new OnConsoleStatusListener();
    LoggingEventBuilderInContext builder = new LoggingEventBuilderInContext(this.loggerContext, this.thisClassName, UnsynchronizedAppenderBase.class.getName());
    int diff = RandomUtil.getPositiveInt();

    @BeforeEach
    public void setUp() {
        this.loggerContext.setMDCAdapter(this.logbackMDCAdapter);
        this.onConsoleStatusListener.setContext((Context)this.loggerContext);
        this.loggerContext.getStatusManager().add((StatusListener)this.onConsoleStatusListener);
        this.onConsoleStatusListener.start();
        this.asyncAppender.setContext((Context)this.loggerContext);
        this.listAppender.setContext((Context)this.loggerContext);
        this.listAppender.setName("list");
        this.listAppender.start();
    }

    @Test
    public void eventWasPreparedForDeferredProcessing() {
        this.asyncAppender.addAppender(this.listAppender);
        this.asyncAppender.start();
        String k = "k" + this.diff;
        this.logbackMDCAdapter.put(k, "v");
        this.asyncAppender.doAppend((Object)this.builder.build(this.diff));
        MDC.clear();
        this.asyncAppender.stop();
        Assertions.assertFalse((boolean)this.asyncAppender.isStarted());
        Assertions.assertEquals((int)1, (int)this.listAppender.list.size());
        ILoggingEvent e = (ILoggingEvent)this.listAppender.list.get(0);
        Assertions.assertEquals((Object)"v", e.getMDCPropertyMap().get(k));
        Assertions.assertFalse((boolean)e.hasCallerData());
    }

    @Test
    public void settingIncludeCallerDataPropertyCausedCallerDataToBeIncluded() {
        this.asyncAppender.addAppender(this.listAppender);
        this.asyncAppender.setIncludeCallerData(true);
        this.asyncAppender.start();
        this.asyncAppender.doAppend((Object)this.builder.build(this.diff));
        this.asyncAppender.stop();
        Assertions.assertEquals((int)1, (int)this.listAppender.list.size());
        ILoggingEvent e = (ILoggingEvent)this.listAppender.list.get(0);
        Assertions.assertTrue((boolean)e.hasCallerData());
        StackTraceElement ste = e.getCallerData()[0];
        Assertions.assertEquals((Object)this.thisClassName, (Object)ste.getClassName());
    }
}

