/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.SocketReceiver;
import ch.qos.logback.classic.net.mock.MockAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.LoggingEventVO;
import ch.qos.logback.classic.util.LogbackMDCAdapter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.net.SocketConnector;
import ch.qos.logback.core.net.server.test.ServerSocketUtil;
import ch.qos.logback.core.status.Status;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SocketReceiverTest {
    private static final int DELAY = 1000;
    private static final String TEST_HOST_NAME = "NOT.A.VALID.HOST.NAME";
    private ServerSocket serverSocket;
    private Socket socket;
    private MockSocketFactory socketFactory = new MockSocketFactory();
    private MockSocketConnector connector;
    private MockAppender appender;
    private LoggerContext lc;
    LogbackMDCAdapter logbackMDCAdapter = new LogbackMDCAdapter();
    private Logger logger;
    private InstrumentedSocketReceiver receiver = new InstrumentedSocketReceiver();

    @BeforeEach
    public void setUp() throws Exception {
        this.serverSocket = ServerSocketUtil.createServerSocket();
        this.socket = new Socket(this.serverSocket.getInetAddress(), this.serverSocket.getLocalPort());
        this.connector = new MockSocketConnector(this.socket);
        this.lc = new LoggerContext();
        this.lc.setMDCAdapter(this.logbackMDCAdapter);
        this.lc.reset();
        this.receiver.setContext((Context)this.lc);
        this.appender = new MockAppender();
        this.appender.start();
        this.logger = this.lc.getLogger(this.getClass());
        this.logger.addAppender((Appender)this.appender);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.receiver.stop();
        ExecutorService executor = this.lc.getExecutorService();
        executor.shutdownNow();
        Assertions.assertTrue((boolean)executor.awaitTermination(1000L, TimeUnit.MILLISECONDS));
        this.socket.close();
        this.serverSocket.close();
        this.lc.stop();
    }

    @Test
    public void testStartNoRemoteAddress() throws Exception {
        this.receiver.start();
        Assertions.assertFalse((boolean)this.receiver.isStarted());
        int count = this.lc.getStatusManager().getCount();
        Status status = (Status)this.lc.getStatusManager().getCopyOfStatusList().get(count - 1);
        Assertions.assertTrue((boolean)status.getMessage().contains("host"));
    }

    @Test
    public void testStartNoPort() throws Exception {
        this.receiver.setRemoteHost(TEST_HOST_NAME);
        this.receiver.start();
        Assertions.assertFalse((boolean)this.receiver.isStarted());
        int count = this.lc.getStatusManager().getCount();
        Status status = (Status)this.lc.getStatusManager().getCopyOfStatusList().get(count - 1);
        Assertions.assertTrue((boolean)status.getMessage().contains("port"));
    }

    @Test
    public void testStartUnknownHost() throws Exception {
        this.receiver.setPort(6000);
        this.receiver.setRemoteHost(TEST_HOST_NAME);
        this.receiver.start();
        Assertions.assertFalse((boolean)this.receiver.isStarted());
        int count = this.lc.getStatusManager().getCount();
        Status status = (Status)this.lc.getStatusManager().getCopyOfStatusList().get(count - 1);
        Assertions.assertTrue((boolean)status.getMessage().contains("unknown host"));
    }

    @Test
    public void testStartStop() throws Exception {
        this.receiver.setRemoteHost(InetAddress.getLocalHost().getHostName());
        this.receiver.setPort(6000);
        this.receiver.setAcceptConnectionTimeout(500);
        this.receiver.start();
        Assertions.assertTrue((boolean)this.receiver.isStarted());
        this.receiver.awaitConnectorCreated(1000L);
        this.receiver.stop();
        Assertions.assertFalse((boolean)this.receiver.isStarted());
    }

    @Test
    public void testServerSlowToAcceptConnection() throws Exception {
        this.receiver.setRemoteHost(InetAddress.getLocalHost().getHostName());
        this.receiver.setPort(6000);
        this.receiver.setAcceptConnectionTimeout(250);
        this.receiver.start();
        Assertions.assertTrue((boolean)this.receiver.awaitConnectorCreated(500L));
    }

    @Test
    public void testServerDropsConnection() throws Exception {
        this.receiver.setRemoteHost(InetAddress.getLocalHost().getHostName());
        this.receiver.setPort(6000);
        this.receiver.start();
        Assertions.assertTrue((boolean)this.receiver.awaitConnectorCreated(1000L));
        Socket socket = this.serverSocket.accept();
        socket.close();
    }

    @Test
    public void testDispatchEventForEnabledLevel() throws Exception {
        this.receiver.setRemoteHost(InetAddress.getLocalHost().getHostName());
        this.receiver.setPort(6000);
        this.receiver.start();
        Assertions.assertTrue((boolean)this.receiver.awaitConnectorCreated(1000L));
        Socket socket = this.serverSocket.accept();
        ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
        this.logger.setLevel(Level.DEBUG);
        LoggingEvent event = new LoggingEvent(this.logger.getName(), this.logger, Level.DEBUG, "test message", null, new Object[0]);
        LoggingEventVO eventVO = LoggingEventVO.build((ILoggingEvent)event);
        oos.writeObject(eventVO);
        oos.flush();
        ILoggingEvent rcvdEvent = this.appender.awaitAppend(1000L);
        Assertions.assertNotNull((Object)rcvdEvent);
        Assertions.assertEquals((Object)event.getLoggerName(), (Object)rcvdEvent.getLoggerName());
        Assertions.assertEquals((Object)event.getLevel(), (Object)rcvdEvent.getLevel());
        Assertions.assertEquals((Object)event.getMessage(), (Object)rcvdEvent.getMessage());
    }

    @Test
    public void testNoDispatchEventForDisabledLevel() throws Exception {
        this.receiver.setRemoteHost(InetAddress.getLocalHost().getHostName());
        this.receiver.setPort(6000);
        this.receiver.start();
        Assertions.assertTrue((boolean)this.receiver.awaitConnectorCreated(1000L));
        Socket socket = this.serverSocket.accept();
        ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
        this.logger.setLevel(Level.INFO);
        LoggingEvent event = new LoggingEvent(this.logger.getName(), this.logger, Level.DEBUG, "test message", null, new Object[0]);
        LoggingEventVO eventVO = LoggingEventVO.build((ILoggingEvent)event);
        oos.writeObject(eventVO);
        oos.flush();
        Assertions.assertNull((Object)this.appender.awaitAppend(1000L));
    }

    private static class MockSocketFactory
    extends SocketFactory {
        private MockSocketFactory() {
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            throw new UnsupportedOperationException();
        }
    }

    private static class MockSocketConnector
    implements SocketConnector {
        private final Socket socket;

        public MockSocketConnector(Socket socket) {
            this.socket = socket;
        }

        public Socket call() throws InterruptedException {
            return this.socket;
        }

        public void setExceptionHandler(SocketConnector.ExceptionHandler exceptionHandler) {
        }

        public void setSocketFactory(SocketFactory socketFactory) {
        }
    }

    private class InstrumentedSocketReceiver
    extends SocketReceiver {
        private boolean connectorCreated;

        private InstrumentedSocketReceiver() {
        }

        protected synchronized SocketConnector newConnector(InetAddress address, int port, int initialDelay, int retryDelay) {
            this.connectorCreated = true;
            ((Object)((Object)this)).notifyAll();
            return SocketReceiverTest.this.connector;
        }

        protected SocketFactory getSocketFactory() {
            return SocketReceiverTest.this.socketFactory;
        }

        public synchronized boolean awaitConnectorCreated(long delay) throws InterruptedException {
            while (!this.connectorCreated) {
                ((Object)((Object)this)).wait(delay);
            }
            return this.connectorCreated;
        }
    }
}

