/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.MDCConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.util.LogbackMDCAdapter;
import ch.qos.logback.core.testUtil.RandomUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MDCConverterTest {
    LoggerContext loggerContext;
    LogbackMDCAdapter logbackMDCAdapter = new LogbackMDCAdapter();
    MDCConverter converter;
    int diff = RandomUtil.getPositiveInt();

    @BeforeEach
    public void setUp() throws Exception {
        this.loggerContext = new LoggerContext();
        this.loggerContext.setMDCAdapter(this.logbackMDCAdapter);
        this.converter = new MDCConverter();
        this.converter.start();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.loggerContext = null;
        this.converter.stop();
        this.converter = null;
    }

    @Test
    public void testConvertWithOneEntry() {
        String k = "MDCConverterTest_k" + this.diff;
        String v = "MDCConverterTest_v" + this.diff;
        this.logbackMDCAdapter.put(k, v);
        ILoggingEvent le = this.createLoggingEvent();
        String result = this.converter.convert(le);
        Assertions.assertEquals((Object)(k + "=" + v), (Object)result);
    }

    @Test
    public void testConvertWithMultipleEntries() {
        this.logbackMDCAdapter.put("testKey", "testValue");
        this.logbackMDCAdapter.put("testKey2", "testValue2");
        ILoggingEvent le = this.createLoggingEvent();
        String result = this.converter.convert(le);
        boolean isConform = result.matches("testKey2?=testValue2?, testKey2?=testValue2?");
        Assertions.assertTrue((boolean)isConform, (String)(result + " is not conform"));
    }

    private ILoggingEvent createLoggingEvent() {
        return new LoggingEvent(this.getClass().getName(), this.loggerContext.getLogger("ROOT"), Level.DEBUG, "test message", null, null);
    }
}

