/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.LoggingEventPreSerializationTransformer;
import ch.qos.logback.classic.net.server.HardenedLoggingEventInputStream;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.LuckyCharms;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyVO;
import ch.qos.logback.classic.util.LogbackMDCAdapter;
import ch.qos.logback.core.spi.PreSerializationTransformer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class LoggingEventSerializationTest {
    LoggerContext loggerContext;
    LogbackMDCAdapter logbackMDCAdapter = new LogbackMDCAdapter();
    Logger logger;
    ByteArrayOutputStream bos;
    ObjectOutputStream oos;
    ObjectInputStream inputStream;
    PreSerializationTransformer<ILoggingEvent> pst = new LoggingEventPreSerializationTransformer();

    @BeforeEach
    public void setUp() throws Exception {
        this.loggerContext = new LoggerContext();
        this.loggerContext.setName("testContext");
        this.loggerContext.setMDCAdapter(this.logbackMDCAdapter);
        this.logger = this.loggerContext.getLogger("ROOT");
        this.bos = new ByteArrayOutputStream();
        this.oos = new ObjectOutputStream(this.bos);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.loggerContext = null;
        this.logger = null;
        this.oos.close();
    }

    @Test
    public void smoke() throws Exception {
        LoggingEvent event = this.createLoggingEvent();
        ILoggingEvent remoteEvent = this.writeAndRead((ILoggingEvent)event);
        this.checkForEquality((ILoggingEvent)event, remoteEvent);
    }

    @Test
    public void context() throws Exception {
        this.loggerContext.putProperty("testKey", "testValue");
        LoggingEvent event = this.createLoggingEvent();
        ILoggingEvent remoteEvent = this.writeAndRead((ILoggingEvent)event);
        this.checkForEquality((ILoggingEvent)event, remoteEvent);
        Assertions.assertNotNull((Object)remoteEvent.getLoggerName());
        Assertions.assertEquals((Object)"ROOT", (Object)remoteEvent.getLoggerName());
        LoggerContextVO loggerContextRemoteView = remoteEvent.getLoggerContextVO();
        Assertions.assertNotNull((Object)loggerContextRemoteView);
        Assertions.assertEquals((Object)"testContext", (Object)loggerContextRemoteView.getName());
        Map props = loggerContextRemoteView.getPropertyMap();
        Assertions.assertNotNull((Object)props);
        Assertions.assertEquals((Object)"testValue", props.get("testKey"));
    }

    @Test
    public void MDC() throws Exception {
        this.logbackMDCAdapter.put("key", "testValue");
        LoggingEvent event = this.createLoggingEvent();
        ILoggingEvent remoteEvent = this.writeAndRead((ILoggingEvent)event);
        this.checkForEquality((ILoggingEvent)event, remoteEvent);
        Map MDCPropertyMap = remoteEvent.getMDCPropertyMap();
        Assertions.assertEquals((Object)"testValue", MDCPropertyMap.get("key"));
    }

    @Test
    public void updatedMDC() throws Exception {
        this.logbackMDCAdapter.put("key", "testValue");
        LoggingEvent event1 = this.createLoggingEvent();
        Serializable s1 = this.pst.transform((Object)event1);
        this.oos.writeObject(s1);
        this.logbackMDCAdapter.put("key", "updatedTestValue");
        LoggingEvent event2 = this.createLoggingEvent();
        Serializable s2 = this.pst.transform((Object)event2);
        this.oos.writeObject(s2);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.bos.toByteArray());
        this.inputStream = new ObjectInputStream(bis);
        this.inputStream.readObject();
        ILoggingEvent remoteEvent2 = (ILoggingEvent)this.inputStream.readObject();
        Map MDCPropertyMap = remoteEvent2.getMDCPropertyMap();
        Assertions.assertEquals((Object)"updatedTestValue", MDCPropertyMap.get("key"));
    }

    @Test
    public void nonSerializableParameters() throws Exception {
        LoggingEvent event = this.createLoggingEvent();
        LuckyCharms lucky0 = new LuckyCharms(0);
        event.setArgumentArray(new Object[]{lucky0, null});
        ILoggingEvent remoteEvent = this.writeAndRead((ILoggingEvent)event);
        this.checkForEquality((ILoggingEvent)event, remoteEvent);
        Object[] aa = remoteEvent.getArgumentArray();
        Assertions.assertNotNull((Object)aa);
        Assertions.assertEquals((int)2, (int)aa.length);
        Assertions.assertEquals((Object)"LC(0)", (Object)aa[0]);
        Assertions.assertNull((Object)aa[1]);
    }

    @Test
    public void testWithThrowable() throws Exception {
        Throwable throwable = new Throwable("just testing");
        LoggingEvent event = this.createLoggingEventWithThrowable(throwable);
        ILoggingEvent remoteEvent = this.writeAndRead((ILoggingEvent)event);
        this.checkForEquality((ILoggingEvent)event, remoteEvent);
    }

    @Test
    public void testWithMarker() throws Exception {
        Marker marker = MarkerFactory.getMarker((String)"A_MARKER");
        LoggingEvent event = this.createLoggingEvent();
        event.addMarker(marker);
        Assertions.assertNotNull((Object)event.getMarkerList());
        ILoggingEvent remoteEvent = this.writeAndRead((ILoggingEvent)event);
        this.checkForEquality((ILoggingEvent)event, remoteEvent);
        Assertions.assertNotNull((Object)remoteEvent.getMarkerList());
        Assertions.assertEquals(Arrays.asList(marker), (Object)remoteEvent.getMarkerList());
    }

    @Test
    public void testWithTwoMarkers() throws Exception {
        Marker marker = MarkerFactory.getMarker((String)"A_MARKER");
        Marker marker2 = MarkerFactory.getMarker((String)"B_MARKER");
        marker.add(marker2);
        LoggingEvent event = this.createLoggingEvent();
        event.addMarker(marker);
        Assertions.assertNotNull((Object)event.getMarkerList());
        ILoggingEvent remoteEvent = this.writeAndRead((ILoggingEvent)event);
        this.checkForEquality((ILoggingEvent)event, remoteEvent);
        Assertions.assertNotNull((Object)remoteEvent.getMarkerList());
        Assertions.assertEquals(Arrays.asList(marker), (Object)remoteEvent.getMarkerList());
    }

    @Test
    public void testWithCallerData() throws Exception {
        LoggingEvent event = this.createLoggingEvent();
        event.getCallerData();
        ILoggingEvent remoteEvent = this.writeAndRead((ILoggingEvent)event);
        this.checkForEquality((ILoggingEvent)event, remoteEvent);
    }

    @Test
    public void extendendeThrowable() throws Exception {
        LoggingEvent event = this.createLoggingEvent();
        Throwable throwable = new Throwable("just testing");
        ThrowableProxy tp = new ThrowableProxy(throwable);
        event.setThrowableProxy(tp);
        tp.calculatePackagingData();
        ILoggingEvent remoteEvent = this.writeAndRead((ILoggingEvent)event);
        this.checkForEquality((ILoggingEvent)event, remoteEvent);
    }

    @Test
    public void serializeLargeArgs() throws Exception {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 100000; ++i) {
            buffer.append("X");
        }
        String largeString = buffer.toString();
        Object[] argArray = new Object[]{new LuckyCharms(2), largeString};
        LoggingEvent event = this.createLoggingEvent();
        event.setArgumentArray(argArray);
        ILoggingEvent remoteEvent = this.writeAndRead((ILoggingEvent)event);
        this.checkForEquality((ILoggingEvent)event, remoteEvent);
        Object[] aa = remoteEvent.getArgumentArray();
        Assertions.assertNotNull((Object)aa);
        Assertions.assertEquals((int)2, (int)aa.length);
        String stringBack = (String)aa[1];
        Assertions.assertEquals((Object)largeString, (Object)stringBack);
    }

    private LoggingEvent createLoggingEvent() {
        return new LoggingEvent(this.getClass().getName(), this.logger, Level.DEBUG, "test message", null, null);
    }

    private LoggingEvent createLoggingEventWithThrowable(Throwable t) {
        return new LoggingEvent(this.getClass().getName(), this.logger, Level.DEBUG, "test message", t, null);
    }

    private void checkForEquality(ILoggingEvent original, ILoggingEvent afterSerialization) {
        Assertions.assertEquals((Object)original.getLevel(), (Object)afterSerialization.getLevel());
        Assertions.assertEquals((Object)original.getFormattedMessage(), (Object)afterSerialization.getFormattedMessage());
        Assertions.assertEquals((Object)original.getMessage(), (Object)afterSerialization.getMessage());
        System.out.println();
        ThrowableProxyVO witness = ThrowableProxyVO.build((IThrowableProxy)original.getThrowableProxy());
        Assertions.assertEquals((Object)witness, (Object)afterSerialization.getThrowableProxy());
    }

    private ILoggingEvent writeAndRead(ILoggingEvent event) throws IOException, ClassNotFoundException {
        Serializable ser = this.pst.transform((Object)event);
        this.oos.writeObject(ser);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.bos.toByteArray());
        this.inputStream = new HardenedLoggingEventInputStream((InputStream)bis);
        return (ILoggingEvent)this.inputStream.readObject();
    }
}

