/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.util.LogbackMDCAdapter;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class LogbackMDCAdapterTest {
    static final String A_SUFFIX = "A_SUFFIX";
    static final String B_SUFFIX = "B_SUFFIX";
    int diff = RandomUtil.getPositiveInt();
    private final LogbackMDCAdapter mdcAdapter = new LogbackMDCAdapter();

    @Test
    public void LOGBACK_442() throws InterruptedException {
        Map<String, String> parentHM = this.getMapFromMDCAdapter(this.mdcAdapter);
        Assertions.assertNull(parentHM);
        ChildThreadForMDCAdapter childThread = new ChildThreadForMDCAdapter(this.mdcAdapter);
        childThread.start();
        childThread.join();
        Assertions.assertTrue((boolean)childThread.successul);
        Assertions.assertNull(childThread.childHM);
    }

    @Test
    public void removeForNullKeyTest() {
        this.mdcAdapter.remove(null);
    }

    @Test
    public void removeInexistentKey() {
        this.mdcAdapter.remove("abcdlw0");
    }

    @Test
    @Disabled
    public void sequenceWithGet() {
        this.mdcAdapter.put("k0", "v0");
        Map map0 = this.mdcAdapter.getPropertyMap();
        this.mdcAdapter.get("k0");
        this.mdcAdapter.put("k1", "v1");
        HashMap<String, String> witness = new HashMap<String, String>();
        witness.put("k0", "v0");
        witness.put("k1", "v1");
        Assertions.assertEquals(witness, (Object)this.mdcAdapter.getPropertyMap());
    }

    @Test
    public void sequenceWithGetPropertyMap() {
        this.mdcAdapter.put("k0", "v0");
        Map map0 = this.mdcAdapter.getPropertyMap();
        this.mdcAdapter.put("k0", "v1");
        Assertions.assertEquals((Object)"v0", map0.get("k0"));
    }

    @Test
    public void basicGetPropertyMap() {
        this.mdcAdapter.put("k0", "v0");
        this.mdcAdapter.put("k1", "v1");
        Map map0 = this.mdcAdapter.getPropertyMap();
        this.mdcAdapter.put("k0", "v1");
        Assertions.assertEquals((Object)"v0", map0.get("k0"));
        Assertions.assertEquals((Object)"v1", map0.get("k1"));
    }

    @Test
    @Disabled
    public void sequenceWithCopyContextMap() {
        this.mdcAdapter.put("k0", "v0");
        Map map0 = this.mdcAdapter.getPropertyMap();
        this.mdcAdapter.getCopyOfContextMap();
        this.mdcAdapter.put("k1", "v1");
        Assertions.assertSame((Object)map0, (Object)this.mdcAdapter.getPropertyMap());
    }

    @Test
    public void noCopyOnInheritenceTest() throws InterruptedException {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        String firstKey = "x" + this.diff;
        String secondKey = "o" + this.diff;
        this.mdcAdapter.put(firstKey, firstKey + A_SUFFIX);
        ChildThread childThread = new ChildThread(this.mdcAdapter, firstKey, secondKey, countDownLatch);
        childThread.start();
        countDownLatch.await();
        this.mdcAdapter.put(firstKey, firstKey + B_SUFFIX);
        childThread.join();
        Assertions.assertNull((Object)this.mdcAdapter.get(secondKey));
        Assertions.assertTrue((boolean)childThread.successful);
        Map<String, String> parentHM = this.getMapFromMDCAdapter(this.mdcAdapter);
        Assertions.assertTrue((parentHM != childThread.childHM ? 1 : 0) != 0);
        HashMap<String, String> parentHMWitness = new HashMap<String, String>();
        parentHMWitness.put(firstKey, firstKey + B_SUFFIX);
        Assertions.assertEquals(parentHMWitness, parentHM);
        HashMap<String, String> childHMWitness = new HashMap<String, String>();
        childHMWitness.put(secondKey, secondKey + A_SUFFIX);
        Assertions.assertEquals(childHMWitness, childThread.childHM);
    }

    @Test
    public void clearOnChildThreadShouldNotAffectParent() throws InterruptedException {
        String firstKey = "x" + this.diff;
        String secondKey = "o" + this.diff;
        this.mdcAdapter.put(firstKey, firstKey + A_SUFFIX);
        Assertions.assertEquals((Object)(firstKey + A_SUFFIX), (Object)this.mdcAdapter.get(firstKey));
        ChildThread clearer = new ChildThread(this.mdcAdapter, firstKey, secondKey){

            @Override
            public void run() {
                LogbackMDCAdapterTest.this.mdcAdapter.clear();
                Assertions.assertNull((Object)LogbackMDCAdapterTest.this.mdcAdapter.get(this.firstKey));
            }
        };
        clearer.start();
        clearer.join();
        Assertions.assertEquals((Object)(firstKey + A_SUFFIX), (Object)this.mdcAdapter.get(firstKey));
    }

    @Test
    public void nearSimultaneousPutsShouldNotCauseConcurrentModificationException() throws InterruptedException {
        for (int i = 0; i < 2048; ++i) {
            this.mdcAdapter.put("k" + i, "v" + i);
        }
        ChildThread childThread = new ChildThread(this.mdcAdapter, null, null){

            @Override
            public void run() {
                for (int i = 0; i < 16; ++i) {
                    LogbackMDCAdapterTest.this.mdcAdapter.put("ck" + i, "cv" + i);
                    Thread.yield();
                }
                this.successful = true;
            }
        };
        childThread.start();
        Thread.sleep(1L);
        for (int i = 0; i < 16; ++i) {
            this.mdcAdapter.put("K" + i, "V" + i);
        }
        childThread.join();
        Assertions.assertTrue((boolean)childThread.successful);
    }

    Map<String, String> getMapFromMDCAdapter(LogbackMDCAdapter lma) {
        ThreadLocal tlMap = lma.readWriteThreadLocalMap;
        return (Map)tlMap.get();
    }

    class ChildThreadForMDCAdapter
    extends Thread {
        LogbackMDCAdapter logbackMDCAdapter;
        boolean successul;
        Map<String, String> childHM;

        ChildThreadForMDCAdapter(LogbackMDCAdapter logbackMDCAdapter) {
            this.logbackMDCAdapter = logbackMDCAdapter;
        }

        @Override
        public void run() {
            this.childHM = LogbackMDCAdapterTest.this.getMapFromMDCAdapter(this.logbackMDCAdapter);
            this.logbackMDCAdapter.get("");
            this.successul = true;
        }
    }

    class ChildThread
    extends Thread {
        LogbackMDCAdapter logbackMDCAdapter;
        String firstKey;
        String secondKey;
        boolean successful;
        Map<String, String> childHM;
        CountDownLatch countDownLatch;

        ChildThread(LogbackMDCAdapter logbackMDCAdapter) {
            this(logbackMDCAdapter, null, null);
        }

        ChildThread(LogbackMDCAdapter logbackMDCAdapter, String firstKey, String secondKey) {
            this(logbackMDCAdapter, firstKey, secondKey, null);
        }

        ChildThread(LogbackMDCAdapter logbackMDCAdapter, String firstKey, String secondKey, CountDownLatch countDownLatch) {
            super("chil");
            this.logbackMDCAdapter = logbackMDCAdapter;
            this.firstKey = firstKey;
            this.secondKey = secondKey;
            this.countDownLatch = countDownLatch;
        }

        @Override
        public void run() {
            this.logbackMDCAdapter.put(this.secondKey, this.secondKey + LogbackMDCAdapterTest.A_SUFFIX);
            Assertions.assertNull((Object)this.logbackMDCAdapter.get(this.firstKey));
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
            }
            Assertions.assertNotNull((Object)this.logbackMDCAdapter.get(this.secondKey));
            Assertions.assertEquals((Object)(this.secondKey + LogbackMDCAdapterTest.A_SUFFIX), (Object)this.logbackMDCAdapter.get(this.secondKey));
            this.successful = true;
            this.childHM = LogbackMDCAdapterTest.this.getMapFromMDCAdapter(this.logbackMDCAdapter);
        }
    }
}

