/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.issue.logback1159;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.issue.logback1159.LoggingError;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.Set;
import org.junit.After;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.LoggerFactoryFriend;

public class LogbackListenerTest {
    private File logFile = new File("target/test.log");

    private void doConfigure() throws JoranException {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)context);
        configurator.doConfigure(new File("src/test/input/issue/logback-1159.xml"));
    }

    @After
    public void after() {
        this.logFile.delete();
        LoggerFactoryFriend.reset();
    }

    private void disableLogFileAccess() throws IOException {
        this.logFile.createNewFile();
        this.logFile.deleteOnExit();
        Path path = Paths.get(this.logFile.toURI());
        Set<PosixFilePermission> permissions = Collections.emptySet();
        try {
            Files.setPosixFilePermissions(path, permissions);
        }
        catch (UnsupportedOperationException e) {
            path.toFile().setReadOnly();
        }
    }

    @Test(expected=LoggingError.class)
    public void testThatErrorIsDetectedAtLogInit() throws Exception {
        this.disableLogFileAccess();
        this.doConfigure();
    }

    @Test
    public void assertThatNonFailSafeAppendersNotAffected() throws JoranException {
        this.doConfigure();
        Logger logger = LoggerFactory.getLogger((String)"NOTJOURNAL");
        logger.error("This should not fail");
    }
}

